/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.shell;

import java.util.EnumSet;
import java.util.Set;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Action;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.popups.ListPopup;

public final class ContextMenu
extends ListPopup<Action> {
    public ContextMenu(Luwrain luwrain, Action[] actions) {
        super(luwrain, ContextMenu.createParams(luwrain, actions), EnumSet.noneOf(Popup.Flags.class));
    }

    private static ListArea.Params<Action> createParams(Luwrain luwrain, Action[] actions) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNullItems((Object[])actions, (String)"actions");
        ListArea.Params<Action> params = new ListArea.Params<Action>();
        params.context = new DefaultControlContext(luwrain);
        params.name = luwrain.i18n().getStaticStr("ContextMenuName");
        params.model = new ListUtils.FixedModel<Action>(actions);
        params.appearance = new Appearance(luwrain);
        params.flags = EnumSet.of(ListArea.Flags.EMPTY_LINE_TOP);
        params.transition = new Transition();
        return params;
    }

    private static final class Appearance
    extends ListUtils.AbstractAppearance<Action> {
        private final Luwrain luwrain;

        Appearance(Luwrain luwrain) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            this.luwrain = luwrain;
        }

        @Override
        public void announceItem(Action action, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)action, (String)"action");
            NullCheck.notNull(flags, (String)"flags");
            this.luwrain.silence();
            this.luwrain.playSound(Sounds.MAIN_MENU_ITEM);
            if (action.inputEvent != null) {
                this.luwrain.speak(action.title + " " + this.luwrain.getSpeakableText(action.inputEvent.toString(), Luwrain.SpeakableTextType.PROGRAMMING));
            } else {
                this.luwrain.speak(action.title);
            }
        }

        @Override
        public String getScreenAppearance(Action action, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)action, (String)"action");
            NullCheck.notNull(flags, (String)"flags");
            if (action.inputEvent != null) {
                return action.title + " (" + String.valueOf(action.inputEvent) + ")";
            }
            return action.title;
        }
    }

    private static final class Transition
    extends ListUtils.DefaultTransition {
        private Transition() {
        }

        @Override
        public ListArea.Transition.State transition(ListArea.Transition.Type type, ListArea.Transition.State fromState, int itemCount, boolean hasEmptyLineTop, boolean hasEmptyLineBottom) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNull((Object)fromState, (String)"fromState");
            if (itemCount == 0) {
                throw new IllegalArgumentException("itemCount must be greater than zero");
            }
            switch (type) {
                case SINGLE_DOWN: {
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX || fromState.itemIndex + 1 != itemCount) {
                        return super.transition(type, fromState, itemCount, hasEmptyLineTop, hasEmptyLineBottom);
                    }
                    return new ListArea.Transition.State(0);
                }
                case SINGLE_UP: {
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX || fromState.itemIndex != 0) {
                        return super.transition(type, fromState, itemCount, hasEmptyLineTop, hasEmptyLineBottom);
                    }
                    return new ListArea.Transition.State(itemCount - 1);
                }
            }
            return super.transition(type, fromState, itemCount, hasEmptyLineTop, hasEmptyLineBottom);
        }
    }
}

