/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import org.luwrain.core.NullCheck;

public class SoundUtils {
    public static byte[] createWaveHeader(int sampleRate, int bitsPerSample, int numChannels, int dataLen) {
        int byteRate;
        switch (bitsPerSample) {
            case 8: {
                byteRate = sampleRate * numChannels;
                break;
            }
            case 16: {
                byteRate = 2 * sampleRate * numChannels;
                break;
            }
            default: {
                return null;
            }
        }
        int totalDataLen = dataLen + 36;
        byte[] header = new byte[]{82, 73, 70, 70, (byte)(totalDataLen & 0xFF), (byte)(totalDataLen >> 8 & 0xFF), (byte)(totalDataLen >> 16 & 0xFF), (byte)(totalDataLen >> 24 & 0xFF), 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, (byte)numChannels, 0, (byte)(sampleRate & 0xFF), (byte)(sampleRate >> 8 & 0xFF), (byte)(sampleRate >> 16 & 0xFF), (byte)(sampleRate >> 24 & 0xFF), (byte)(byteRate & 0xFF), (byte)(byteRate >> 8 & 0xFF), (byte)(byteRate >> 16 & 0xFF), (byte)(byteRate >> 24 & 0xFF), (byte)(numChannels * bitsPerSample / 8), 0, (byte)bitsPerSample, 0, 100, 97, 116, 97, (byte)(dataLen & 0xFF), (byte)(dataLen >> 8 & 0xFF), (byte)(dataLen >> 16 & 0xFF), (byte)(dataLen >> 24 & 0xFF)};
        return header;
    }

    public static byte[] createWaveHeader(AudioFormat audioFormat, int dataLen) {
        NullCheck.notNull((Object)audioFormat, (String)"audioFormat");
        return SoundUtils.createWaveHeader((int)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), dataLen);
    }

    public static AudioFormat createAudioFormat(String params) {
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        float sampleRate = 24000.0f;
        int channels = 2;
        int bitsInSample = 16;
        boolean bigEndian = false;
        block24: for (String p : params.split(",", -1)) {
            if (p.isEmpty()) continue;
            switch (p.trim().toLowerCase()) {
                case "mono": {
                    channels = 1;
                    continue block24;
                }
                case "stereo": {
                    channels = 2;
                    continue block24;
                }
                case "8bit": 
                case "8bits": {
                    bitsInSample = 8;
                    continue block24;
                }
                case "16bit": 
                case "16bits": {
                    bitsInSample = 16;
                    continue block24;
                }
                case "bigendian": {
                    bigEndian = true;
                    continue block24;
                }
                case "littleEndian": {
                    bigEndian = false;
                    continue block24;
                }
                case "signed": {
                    encoding = AudioFormat.Encoding.PCM_SIGNED;
                    continue block24;
                }
                case "unsigned": {
                    encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    continue block24;
                }
                default: {
                    try {
                        sampleRate = Float.parseFloat(p.trim());
                    }
                    catch (NumberFormatException e) {}
                    continue block24;
                }
            }
        }
        return new AudioFormat(encoding, sampleRate, bitsInSample, channels, 1 * bitsInSample / 8, sampleRate, bigEndian);
    }

    public static boolean setLineMasterGanePercent(SourceDataLine line, int percent) {
        NullCheck.notNull((Object)line, (String)"line");
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException("The percent number (" + percent + ") may not be less than 0 or greater than 100");
        }
        if (!line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            return false;
        }
        FloatControl control = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
        float min = control.getMinimum();
        float max = control.getMinimum() < 0.0f ? Math.min(control.getMaximum(), 0.0f) : control.getMaximum();
        float value = min + (max - min) * ((float)percent / 100.0f);
        control.setValue(value);
        return true;
    }
}

