/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.util.function.Predicate;
import org.luwrain.core.Lines;
import org.luwrain.core.NullCheck;

public final class TextFragmentUtils {
    private final Lines lines;

    public TextFragmentUtils(Lines lines) {
        NullCheck.notNull((Object)lines, (String)"lines");
        this.lines = lines;
    }

    String getWord(int pos, int lineIndex, Predicate<Character> wordCharCond) {
        int posFrom;
        NullCheck.notNull(wordCharCond, (String)"wordCharCond");
        if (pos < 0) {
            throw new IllegalArgumentException("pos can't be negative");
        }
        if (lineIndex < 0) {
            throw new IllegalArgumentException("lineIndex can't be negative");
        }
        if (lineIndex >= this.lines.getLineCount()) {
            return null;
        }
        String line = this.lines.getLine(lineIndex);
        if (line == null) {
            return null;
        }
        if (pos >= line.length()) {
            return null;
        }
        if (!wordCharCond.test(Character.valueOf(line.charAt(pos)))) {
            return null;
        }
        int posTo = pos;
        for (posFrom = pos; posFrom > 0 && wordCharCond.test(Character.valueOf(line.charAt(posFrom - 1))); --posFrom) {
        }
        while (posTo + 1 < line.length() && wordCharCond.test(Character.valueOf(line.charAt(posTo + 1)))) {
            ++posTo;
        }
        return line.substring(posFrom, posTo + 1);
    }

    public String getWord(int pos, int lineIndex) {
        return this.getWord(pos, lineIndex, ch -> Character.isLetter(ch.charValue()) || ch.charValue() == '-');
    }

    String replaceWord(int pos, int lineIndex, String replaceWith, Predicate<Character> wordCharCond) {
        int posFrom;
        NullCheck.notNull(wordCharCond, (String)"wordCharCond");
        NullCheck.notNull((Object)replaceWith, (String)"replaceWith");
        if (pos < 0) {
            throw new IllegalArgumentException("pos can't be negative");
        }
        if (lineIndex < 0) {
            throw new IllegalArgumentException("lineIndex can't be negative");
        }
        if (lineIndex >= this.lines.getLineCount()) {
            return null;
        }
        String line = this.lines.getLine(lineIndex);
        if (line == null) {
            return null;
        }
        if (pos >= line.length()) {
            return null;
        }
        if (!wordCharCond.test(Character.valueOf(line.charAt(pos)))) {
            return null;
        }
        int posTo = pos;
        for (posFrom = pos; posFrom > 0 && wordCharCond.test(Character.valueOf(line.charAt(posFrom - 1))); --posFrom) {
        }
        while (posTo + 1 < line.length() && wordCharCond.test(Character.valueOf(line.charAt(posTo + 1)))) {
            ++posTo;
        }
        return line.substring(0, posFrom) + replaceWith + line.substring(posTo + 1);
    }

    public String replaceWord(int pos, int lineIndex, String replaceWith) {
        NullCheck.notNull((Object)replaceWith, (String)"replaceWith");
        return this.replaceWord(pos, lineIndex, replaceWith, ch -> Character.isLetter(ch.charValue()) || ch.charValue() == '-');
    }
}

