/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.luwrain.core.NullCheck;

public final class Urls {
    public static File toFile(URL url) {
        NullCheck.notNull((Object)url, (String)"url");
        if (url.getProtocol() == null || !url.getProtocol().toLowerCase().equals("file")) {
            return null;
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static URL toUrl(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        try {
            return file.toURI().toURL();
        }
        catch (IOException e) {
            return null;
        }
    }
}

