/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.js;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.js.Conv;
import org.luwrain.app.js.MainLayout;
import org.luwrain.app.js.Script;
import org.luwrain.app.js.Scripts;
import org.luwrain.app.js.Strings;
import org.luwrain.core.AreaLayout;

public final class App
extends AppBase<Strings> {
    private Conv conv = null;
    private File scriptsFile = null;
    private Scripts scripts = null;
    private MainLayout mainLayout = null;

    public App() {
        super(Strings.class, "luwrain.js");
    }

    protected AreaLayout onAppInit() throws IOException {
        File dataDir = this.getLuwrain().getAppDataDir("luwrain.studio.js").toFile();
        this.scriptsFile = new File(dataDir, "scripts.json");
        if (!this.scriptsFile.exists()) {
            this.scripts = new Scripts();
            this.scripts.scripts = new ArrayList<Script>();
        } else {
            this.scripts = Scripts.load(this.scriptsFile);
        }
        if (this.scripts.scripts.isEmpty()) {
            this.scripts.scripts.add(new Script("default"));
        }
        this.conv = new Conv(this);
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        return this.mainLayout.getAreaLayout();
    }

    Layouts layouts() {
        return new Layouts(){

            @Override
            public void main() {
            }
        };
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    void save() {
        try {
            Scripts.save(this.scriptsFile, this.scripts);
        }
        catch (IOException e) {
            this.crash(e);
        }
    }

    Conv getConv() {
        return this.conv;
    }

    Scripts getScripts() {
        return this.scripts;
    }

    static interface Layouts {
        public void main();
    }
}

