/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.studio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.studio.App;
import org.luwrain.app.studio.ProjectBaseLayout;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.NavigationArea;
import org.luwrain.controls.TreeListArea;
import org.luwrain.controls.WrappingControlContext;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Luwrain;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.studio.Part;
import org.luwrain.studio.TextEditing;
import org.luwrain.studio.edit.TextEditingBase;

public final class TextEditingLayout
extends LayoutBase {
    private final App app;
    final TreeListArea<Part> treeArea;
    final EditArea editArea;
    final NavigationArea outputArea = null;
    private final TextEditing textEditing;
    private boolean showTree = true;
    private boolean showOutput = false;

    TextEditingLayout(final App app, ProjectBaseLayout projectBaseLayout, final TextEditing textEditing) {
        super((AppBase)app);
        TextEditingBase base;
        this.app = app;
        this.showTree = !app.isSingleFileProject();
        this.textEditing = textEditing;
        WrappingControlContext editingControlContext = new WrappingControlContext(this.getControlContext()){

            public void onAreaNewHotPoint(Area area) {
                textEditing.onNewHotPoint(area.getHotPointX(), area.getHotPointY());
                super.onAreaNewHotPoint(area);
            }
        };
        this.treeArea = projectBaseLayout.treeArea;
        EditArea.Params editParams = textEditing.getEditParams((ControlContext)editingControlContext);
        this.editArea = new EditArea(editParams){
            private final Map<String, Part.Action> actionsCache;
            {
                super(params);
                this.actionsCache = new HashMap<String, Part.Action>();
            }

            public boolean onInputEvent(InputEvent event) {
                if (event.equals(ProjectBaseLayout.KEY_TREE_TOGGLE)) {
                    TextEditingLayout.this.showTree = true;
                    TextEditingLayout.this.updateAreaLayout();
                    app.setAreaLayout(TextEditingLayout.this);
                    TextEditingLayout.this.setActiveArea((Area)TextEditingLayout.this.treeArea);
                    return true;
                }
                if (event.isSpecial() && !event.isModified()) {
                    switch (event.getSpecial()) {
                        case TAB: {
                            return TextEditingLayout.this.fixIndent();
                        }
                    }
                }
                return super.onInputEvent(event);
            }

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case ACTION: {
                            ActionEvent actionEvent = (ActionEvent)event;
                            String actionName = actionEvent.getActionName();
                            Part.Action partAction = this.actionsCache.get(actionName);
                            if (partAction == null) {
                                return false;
                            }
                            return partAction.onAction(app.ide);
                        }
                        case SAVE: {
                            return TextEditingLayout.this.onSave();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }

            public Action[] getAreaActions() {
                Part.Action[] actions = textEditing.getActions();
                this.actionsCache.clear();
                ArrayList<Action> res = new ArrayList<Action>();
                int k = 1;
                for (Part.Action a : actions) {
                    Action action = a.getHotKey() != null ? new Action("action" + k++, a.getTitle(), a.getHotKey()) : new Action("action" + k++, a.getTitle());
                    this.actionsCache.put(action.name, a);
                    res.add(action);
                }
                return res.toArray(new Action[res.size()]);
            }
        };
        if (textEditing instanceof TextEditingBase && ((base = (TextEditingBase)textEditing).getHotPointX() > 0 || base.getHotPointY() > 0)) {
            this.editArea.setHotPoint(base.getHotPointX(), base.getHotPointY());
        }
        this.updateAreaLayout();
    }

    private boolean onSave() {
        try {
            if (!this.textEditing.save()) {
                return false;
            }
            this.app.message("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e", Luwrain.MessageType.OK);
            return true;
        }
        catch (IOException e) {
            this.app.crash(e);
            return true;
        }
    }

    private boolean fixIndent() {
        return false;
    }

    private void updateAreaLayout() {
        if (this.showTree) {
            this.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.treeArea, null, (Area)this.editArea, null);
        } else {
            this.setAreaLayout((Area)this.editArea, null);
        }
    }

    boolean activateEditArea(boolean closeTree) {
        this.showTree = !closeTree;
        this.updateAreaLayout();
        this.app.setAreaLayout(this);
        this.setActiveArea((Area)this.editArea);
        return true;
    }
}

