/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.proj.main;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.popups.Popups;
import org.luwrain.studio.Editing;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.edit.tex.TexSourceFile;
import org.luwrain.studio.proj.main.ProjectImpl;

public final class Folder
implements Part {
    private String name = "";
    private List<Folder> subfolders = null;
    private List<TexSourceFile> texFiles = null;
    private transient ProjectImpl proj = null;
    private transient IDE ide = null;

    void init(ProjectImpl proj, IDE ide) {
        NullCheck.notNull((Object)proj, (String)"proj");
        NullCheck.notNull((Object)ide, (String)"ide");
        this.proj = proj;
        this.ide = ide;
        if (this.name == null) {
            this.name = "---";
        }
        if (this.subfolders == null) {
            this.subfolders = new ArrayList<Folder>();
        }
        if (this.texFiles == null) {
            this.texFiles = new ArrayList<TexSourceFile>();
        }
        for (Folder folder : this.subfolders) {
            folder.init(proj, ide);
        }
        for (TexSourceFile texSourceFile : this.texFiles) {
            texSourceFile.init(proj, ide);
        }
    }

    @Override
    public Part[] getChildParts() {
        ArrayList<Part> res = new ArrayList<Part>();
        if (this.subfolders != null) {
            for (Part part : this.subfolders) {
                res.add(part);
            }
        }
        if (this.texFiles != null) {
            for (Part part : this.texFiles) {
                res.add(part);
            }
        }
        return res.toArray(new Part[res.size()]);
    }

    public void setName(String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        this.name = name;
    }

    public void setSubfolders(List<Folder> subfolders) {
        NullCheck.notNull(subfolders, (String)"subfolders");
        this.subfolders = subfolders;
    }

    public List<TexSourceFile> getTexFiles() {
        if (this.texFiles == null) {
            this.texFiles = new ArrayList<TexSourceFile>();
        }
        return this.texFiles;
    }

    public void setTexFiles(List<TexSourceFile> texFiles) {
        this.texFiles = texFiles;
    }

    @Override
    public Part.Action[] getActions() {
        return Part.actions(Part.action("\u041d\u043e\u0432\u044b\u0439 \u0440\u0430\u0437\u0434\u0435\u043b", new InputEvent(InputEvent.Special.INSERT, EnumSet.of(InputEvent.Modifiers.CONTROL)), this::newSubfolder), Part.action("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0444\u0430\u0439\u043b", new InputEvent(InputEvent.Special.INSERT), this::newSourceFile));
    }

    @Override
    public Editing startEditing() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public List<Folder> getSubfolders() {
        return this.subfolders != null ? this.subfolders : new ArrayList<Folder>();
    }

    private boolean newSubfolder(IDE ide) {
        return true;
    }

    private boolean newSourceFile(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        String name = Popups.textNotEmpty((Luwrain)ide.getLuwrainObj(), (String)"\u041d\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b", (String)"\u0418\u043c\u044f:", (String)"");
        if (name == null) {
            return true;
        }
        String path = Popups.textNotEmpty((Luwrain)ide.getLuwrainObj(), (String)"\u041d\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b", (String)"\u041f\u0443\u0442\u044c :", (String)"");
        if (path == null) {
            return true;
        }
        TexSourceFile newFile = new TexSourceFile(name, path);
        newFile.init(this.proj, ide);
        this.texFiles.add(newFile);
        ide.onFoldersUpdate();
        return true;
    }
}

