/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.linux_term;

import com.pty4j.PtyProcessBuilder;
import com.pty4j.unix.UnixPtyProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.FutureTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.linux_term.MainLayout;
import org.luwrain.app.linux_term.Strings;
import org.luwrain.app.linux_term.TermInfo;
import org.luwrain.core.AreaLayout;

public final class App
extends AppBase<Strings> {
    private static final Logger log = LogManager.getLogger();
    private static final long LISTENING_DELAY = 10L;
    final TermInfo termInfo;
    final String startingDir;
    private UnixPtyProcess pty = null;
    private MainLayout layout = null;
    private volatile StringBuilder termOutput = new StringBuilder();
    private volatile long latestOutputTimestamp = new Date().getTime();

    public App(TermInfo termInfo) {
        super(Strings.class, "luwrain.linux.term");
        this.termInfo = Objects.requireNonNull(termInfo, "termInfo can't be null");
        this.startingDir = null;
    }

    public App(TermInfo termInfo, String startingDir) {
        super(Strings.class, "luwrain.linux.term");
        this.termInfo = Objects.requireNonNull(termInfo, "termInfo can't be null");
        this.startingDir = startingDir;
    }

    public AreaLayout onAppInit() throws IOException {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.put("TERM", "linux");
        this.pty = (UnixPtyProcess)new PtyProcessBuilder(new String[]{"/bin/bash", "-l"}).setEnvironment(env).setDirectory(this.startingDir != null && !this.startingDir.isEmpty() ? this.startingDir : this.getLuwrain().getProperty("luwrain.dir.userhome")).setConsole(false).start();
        this.getLuwrain().executeBkg(new FutureTask<Object>(() -> this.readOutput(), null));
        this.getLuwrain().executeBkg(new FutureTask<Object>(() -> this.listening(), null));
        this.setAppName(((Strings)this.getStrings()).appName());
        this.layout = new MainLayout(this);
        return this.layout.getLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOutput() {
        try {
            try {
                InputStream is = this.pty.getInputStream();
                InputStreamReader r = new InputStreamReader(is, "UTF-8");
                while (this.pty.isRunning()) {
                    int c = r.read();
                    if (c < 0) {
                        log.debug("Negative character from the terminal: " + c);
                        break;
                    }
                    App app = this;
                    synchronized (app) {
                        this.termOutput.append((char)c);
                        this.latestOutputTimestamp = new Date().getTime();
                    }
                }
                log.debug("Closing the terminal");
                r.close();
                is.close();
                try {
                    this.pty.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                log.debug("Exit value is " + this.pty.exitValue());
            }
            catch (Exception e) {
                this.crash(e);
            }
        }
        catch (Throwable t) {
            log.error("PPTY failure", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listening() {
        try {
            while (this.pty.isRunning()) {
                String output;
                App app;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.debug("Finishing listening thread, running=" + this.pty.isRunning());
                    app = this;
                    synchronized (app) {
                        String output2 = new String(this.termOutput);
                        this.termOutput = new StringBuilder();
                        if (!output2.isEmpty()) {
                            this.getLuwrain().runUiSafely(() -> {
                                if (this.layout != null) {
                                    this.layout.termText(output2);
                                }
                            });
                        }
                    }
                    return;
                }
                app = this;
                synchronized (app) {
                    if (this.termOutput.length() == 0) {
                        continue;
                    }
                    long timestamp = new Date().getTime();
                    if (timestamp - this.latestOutputTimestamp < 10L) {
                        continue;
                    }
                    output = new String(this.termOutput);
                    this.termOutput = new StringBuilder();
                }
                this.getLuwrain().runUiSafely(() -> {
                    if (this.layout != null) {
                        this.layout.termText(output);
                    }
                });
            }
        }
        finally {
            log.debug("Finishing listening thread, running=" + this.pty.isRunning());
            App app = this;
            synchronized (app) {
                String output = new String(this.termOutput);
                this.termOutput = new StringBuilder();
                if (!output.isEmpty()) {
                    this.getLuwrain().runUiSafely(() -> {
                        if (this.layout != null) {
                            this.layout.termText(output2);
                        }
                    });
                }
            }
        }
    }

    void sendChar(char ch) {
        try {
            if (ch < ' ') {
                this.pty.getOutputStream().write((byte)ch);
                return;
            }
            OutputStreamWriter w = new OutputStreamWriter(this.pty.getOutputStream(), "UTF-8");
            w.write(ch);
            w.flush();
        }
        catch (IOException e) {
            this.getLuwrain().crash((Throwable)e);
        }
    }

    public void closeApp() {
        this.pty.hangup();
        this.pty.destroy();
        super.closeApp();
    }
}

