/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.messages.Conversation;
import com.vk.api.sdk.objects.messages.ConversationWithMessage;
import com.vk.api.sdk.objects.messages.Message;
import java.util.EnumSet;
import java.util.Set;
import org.luwrain.app.vk.Actions;
import org.luwrain.app.vk.Base;
import org.luwrain.app.vk.MessagesArea;
import org.luwrain.app.vk.NotificationNewMessage;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BackgroundSoundQuery;

final class ConversationsArea
extends ListArea
implements NotificationNewMessage {
    private final Base base;
    private final Actions actions;
    private final Runnable closing;
    private MessagesArea messagesArea = null;
    private Area defaultArea = null;

    ConversationsArea(Base base, Actions actions, Runnable closing) {
        super(ConversationsArea.createParams(base));
        NullCheck.notNull((Object)actions, (String)"actions");
        NullCheck.notNull((Object)closing, (String)"closing");
        this.base = base;
        this.actions = actions;
        this.closing = closing;
        this.setListClickHandler((area, index, obj) -> {
            NullCheck.notNull((Object)obj, (String)"obj");
            if (!(obj instanceof ConversationWithMessage)) {
                return false;
            }
            ConversationWithMessage conv = (ConversationWithMessage)obj;
            return actions.onMessagesHistory(conv, () -> {
                Message message = conv.getLastMessage();
                int userId = message.getOut() == BoolInt.YES ? message.getPeerId() : message.getFromId();
                this.messagesArea.activateConv(userId);
            });
        });
        actions.onConversationsUpdate(() -> {
            base.luwrain.setActiveArea((Area)this);
            this.refresh();
        });
    }

    @Override
    public void onMessage(int messageId, int peerId, String messageText) {
        this.actions.onConversationsUpdateNonInteractive(() -> this.refresh());
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case TAB: {
                    if (this.messagesArea == null) {
                        return false;
                    }
                    this.base.luwrain.setActiveArea((Area)this.messagesArea);
                    return true;
                }
                case BACKSPACE: {
                    if (this.defaultArea == null) {
                        return false;
                    }
                    this.base.luwrain.setActiveArea(this.defaultArea);
                    return true;
                }
                case ESCAPE: {
                    this.closing.run();
                    return true;
                }
            }
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case CLOSE: {
                this.base.closeApp();
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 7: {
                if (this.base.isBusy()) {
                    ((BackgroundSoundQuery)query).answer(new BackgroundSoundQuery.Answer(BkgSounds.FETCHING));
                    return true;
                }
                return false;
            }
        }
        return super.onAreaQuery(query);
    }

    public Action[] getAreaActions() {
        return this.actions.lists.getConversationsActions();
    }

    void setMessagesArea(MessagesArea messagesArea) {
        NullCheck.notNull((Object)messagesArea, (String)"messagesArea");
        if (this.messagesArea != null) {
            throw new RuntimeException("messagesArea already set");
        }
        this.messagesArea = messagesArea;
    }

    void setDefaultArea(Area defaultArea) {
        NullCheck.notNull((Object)defaultArea, (String)"defaultArea");
        if (this.defaultArea != null) {
            throw new RuntimeException("defaultArea already set");
        }
        this.defaultArea = defaultArea;
    }

    private static ListArea.Params createParams(Base base) {
        NullCheck.notNull((Object)base, (String)"base");
        ListArea.Params params = new ListArea.Params();
        params.context = new DefaultControlContext(base.luwrain);
        params.model = base.getConversationsListModel();
        params.appearance = new Appearance(base);
        params.name = base.strings.conversationsAreaName();
        return params;
    }

    private static final class Appearance
    implements ListArea.Appearance<Object> {
        private final Base base;

        Appearance(Base base) {
            NullCheck.notNull((Object)base, (String)"base");
            this.base = base;
        }

        public void announceItem(Object item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            if (item instanceof ConversationWithMessage) {
                Conversation conv = ((ConversationWithMessage)item).getConversation();
                Message message = ((ConversationWithMessage)item).getLastMessage();
                boolean noUnread = message.getOut() == BoolInt.YES ? conv.getOutRead().equals(message.getId()) : conv.getInRead().equals(message.getId());
                String title = message.getOut() == BoolInt.YES ? this.base.getUserCommonName(message.getPeerId()) : this.base.getUserCommonName(message.getFromId());
                Sounds sound = message.getOut() == BoolInt.YES ? (noUnread ? Sounds.SELECTED : Sounds.LIST_ITEM) : (noUnread ? Sounds.SELECTED : Sounds.ATTENTION);
                this.base.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)sound, (String)(title + ": " + message.getText()), null));
                return;
            }
            this.base.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)item.toString(), null));
        }

        public String getScreenAppearance(Object item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            if (item instanceof ConversationWithMessage) {
                Conversation dialog = ((ConversationWithMessage)item).getConversation();
                Message message = ((ConversationWithMessage)item).getLastMessage();
                if (dialog.getUnreadCount() != null) {
                    return this.base.getUserCommonName(message.getFromId()) + " (" + dialog.getUnreadCount() + "): " + message.getText();
                }
                return this.base.getUserCommonName(message.getFromId()) + ": " + message.getText();
            }
            return item.toString();
        }

        public int getObservableLeftBound(Object item) {
            return 0;
        }

        public int getObservableRightBound(Object item) {
            return this.getScreenAppearance(item, EnumSet.noneOf(ListArea.Appearance.Flags.class)).length();
        }
    }
}

