/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import com.vk.api.sdk.objects.messages.Message;
import org.luwrain.app.vk.Actions;
import org.luwrain.app.vk.Base;
import org.luwrain.app.vk.ConversationsArea;
import org.luwrain.app.vk.NotificationNewMessage;
import org.luwrain.app.vk.Strings;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BackgroundSoundQuery;

class MessagesArea
extends ConsoleArea
implements NotificationNewMessage {
    private final Luwrain luwrain;
    private final Strings strings;
    private final Base base;
    private final Actions actions;
    private final Runnable closing;
    private int activeUserId = -1;
    private ConversationsArea conversationsArea = null;
    private Area defaultArea = null;

    MessagesArea(Luwrain luwrain, Strings strings, Base base, Actions actions, Runnable closing) {
        super(MessagesArea.createParams(luwrain, strings, base));
        NullCheck.notNull((Object)actions, (String)"actions");
        NullCheck.notNull((Object)closing, (String)"closing");
        this.luwrain = luwrain;
        this.strings = strings;
        this.base = base;
        this.actions = actions;
        this.closing = closing;
        this.setInputPrefix(">");
        this.setConsoleClickHandler((area, index, obj) -> {
            if (obj == null) {
                return false;
            }
            return false;
        });
        this.setConsoleInputHandler((area, text) -> {
            NullCheck.notNull((Object)text, (String)"text");
            if (this.activeUserId < 0 || text.trim().isEmpty() || base.isBusy()) {
                return ConsoleArea.InputHandler.Result.REJECTED;
            }
            if (!actions.onMessageSend(this.activeUserId, text, () -> {
                this.refresh();
                luwrain.onAreaNewBackgroundSound((Area)this);
                luwrain.playSound(base.users.length > 0 ? Sounds.OK : Sounds.OK);
            })) {
                return ConsoleArea.InputHandler.Result.REJECTED;
            }
            luwrain.onAreaNewBackgroundSound((Area)area);
            return ConsoleArea.InputHandler.Result.CLEAR_INPUT;
        });
    }

    void activateConv(int userId) {
        if (userId < 0) {
            throw new IllegalArgumentException("userId (" + userId + ") may not be negative");
        }
        this.activeUserId = userId;
        this.setInputPrefix(this.base.getUserCommonName(userId) + ">");
        this.refresh();
        this.luwrain.setActiveArea((Area)this);
    }

    @Override
    public void onMessage(int messageId, int peerId, String messageText) {
        if (this.activeUserId < 0) {
            return;
        }
        this.actions.onMessagesHistoryNonInteractive(this.activeUserId, () -> this.refresh());
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case TAB: {
                    if (this.defaultArea == null) {
                        return false;
                    }
                    this.luwrain.setActiveArea(this.defaultArea);
                    return true;
                }
                case ESCAPE: {
                    this.closing.run();
                    return true;
                }
            }
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case CLOSE: {
                this.base.closeApp();
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 7: {
                if (this.base.isBusy()) {
                    ((BackgroundSoundQuery)query).answer(new BackgroundSoundQuery.Answer(BkgSounds.FETCHING));
                    return true;
                }
                return false;
            }
        }
        return super.onAreaQuery(query);
    }

    void setConversationsArea(ConversationsArea conversationsArea) {
        NullCheck.notNull((Object)conversationsArea, (String)"conversationsArea");
        if (this.conversationsArea != null) {
            throw new RuntimeException("conversationsArea already set");
        }
        this.conversationsArea = conversationsArea;
    }

    void setDefaultArea(Area defaultArea) {
        NullCheck.notNull((Object)defaultArea, (String)"defaultArea");
        if (this.defaultArea != null) {
            throw new RuntimeException("defaultArea already set");
        }
        this.defaultArea = defaultArea;
    }

    private static ConsoleArea.Params createParams(Luwrain luwrain, Strings strings, Base base) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)base, (String)"base");
        ConsoleArea.Params params = new ConsoleArea.Params();
        params.context = new DefaultControlContext(luwrain);
        params.model = new Model(base);
        params.appearance = new Appearance(luwrain);
        params.name = strings.messagesAreaName();
        params.inputPos = ConsoleArea.InputPos.TOP;
        return params;
    }

    private static final class Model
    implements ConsoleArea.Model {
        private final Base base;

        Model(Base base) {
            NullCheck.notNull((Object)base, (String)"base");
            this.base = base;
        }

        public int getItemCount() {
            NullCheck.notNullItems((Object[])this.base.messages, (String)"base.messages");
            return this.base.messages.length;
        }

        public Object getItem(int index) {
            NullCheck.notNullItems((Object[])this.base.messages, (String)"base.messages");
            return this.base.messages[index];
        }
    }

    private static final class Appearance
    implements ConsoleArea.Appearance {
        private final Luwrain luwrain;

        Appearance(Luwrain luwrain) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            this.luwrain = luwrain;
        }

        public void announceItem(Object item) {
            NullCheck.notNull((Object)item, (String)"item");
            if (item instanceof Message) {
                Message message = (Message)item;
                this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)message.getText(), null));
                return;
            }
            this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)item.toString(), null));
        }

        public String getTextAppearance(Object item) {
            NullCheck.notNull((Object)item, (String)"item");
            if (item instanceof Message) {
                Message message = (Message)item;
                return message.getText();
            }
            return item.toString();
        }
    }
}

