/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import com.vk.api.sdk.objects.users.UserFull;
import java.util.Date;
import org.luwrain.app.vk.Actions;
import org.luwrain.app.vk.Base;
import org.luwrain.app.vk.Strings;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.core.Action;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Event;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BackgroundSoundQuery;

abstract class UsersArea
extends ConsoleArea {
    private final Luwrain luwrain;
    private final Strings strings;
    private final Base base;
    private final Actions actions;
    private final Runnable closing;

    UsersArea(Luwrain luwrain, Strings strings, Base base, Actions actions, Runnable closing) {
        super(UsersArea.createParams(luwrain, strings, base));
        NullCheck.notNull((Object)actions, (String)"actions");
        NullCheck.notNull((Object)closing, (String)"closing");
        this.luwrain = luwrain;
        this.strings = strings;
        this.base = base;
        this.actions = actions;
        this.closing = closing;
        this.setInputPrefix(strings.search() + ">");
        this.setConsoleClickHandler((area, index, obj) -> {
            if (obj == null || !(obj instanceof UserFull)) {
                return false;
            }
            return this.onClick((UserFull)obj);
        });
        this.setConsoleInputHandler((area, text) -> {
            NullCheck.notNull((Object)text, (String)"text");
            if (text.trim().isEmpty() || base.isBusy()) {
                return ConsoleArea.InputHandler.Result.REJECTED;
            }
            if (!actions.onUsersSearch(text, () -> {
                area.refresh();
                luwrain.playSound(base.users.length > 0 ? Sounds.OK : Sounds.ERROR);
            })) {
                return ConsoleArea.InputHandler.Result.REJECTED;
            }
            return ConsoleArea.InputHandler.Result.OK;
        });
    }

    abstract boolean onClick(UserFull var1);

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ESCAPE: {
                    this.closing.run();
                    return true;
                }
            }
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case ACTION: {
                if (ActionEvent.isAction((Event)event, (String)"request-friendship")) {
                    return this.onRequestFriendship();
                }
                if (ActionEvent.isAction((Event)event, (String)"message")) {
                    return this.onMessage();
                }
                return false;
            }
            case CLOSE: {
                this.base.closeApp();
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 7: {
                if (this.base.isBusy()) {
                    ((BackgroundSoundQuery)query).answer(new BackgroundSoundQuery.Answer(BkgSounds.FETCHING));
                    return true;
                }
                return false;
            }
        }
        return super.onAreaQuery(query);
    }

    public Action[] getAreaActions() {
        return this.actions.lists.getUsersActions();
    }

    private boolean onRequestFriendship() {
        Object selected = this.selected();
        if (selected == null || !(selected instanceof UserFull)) {
            return false;
        }
        UserFull user = (UserFull)selected;
        return this.actions.onNewFriendship(user.getId(), () -> this.luwrain.message(this.strings.friendshipRequestSent(), Luwrain.MessageType.OK));
    }

    private boolean onMessage() {
        Object selected = this.selected();
        if (selected == null || !(selected instanceof UserFull)) {
            return false;
        }
        UserFull user = (UserFull)selected;
        String text = this.actions.conv.messageText();
        if (text == null || text.trim().isEmpty()) {
            return true;
        }
        return this.actions.onMessageSend(user.getId(), text, () -> this.luwrain.message(this.strings.messageSent(), Luwrain.MessageType.OK));
    }

    private static ConsoleArea.Params createParams(Luwrain luwrain, Strings strings, Base base) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)base, (String)"base");
        ConsoleArea.Params params = new ConsoleArea.Params();
        params.context = new DefaultControlContext(luwrain);
        params.model = new Model(base);
        params.appearance = new Appearance(luwrain, strings);
        params.name = strings.usersAreaName();
        params.inputPos = ConsoleArea.InputPos.TOP;
        return params;
    }

    private static final class Model
    implements ConsoleArea.Model {
        private final Base base;

        Model(Base base) {
            NullCheck.notNull((Object)base, (String)"base");
            this.base = base;
        }

        public int getItemCount() {
            NullCheck.notNullItems((Object[])this.base.users, (String)"base.users");
            return this.base.users.length;
        }

        public Object getItem(int index) {
            NullCheck.notNullItems((Object[])this.base.users, (String)"base.users");
            return this.base.users[index];
        }
    }

    private static final class Appearance
    implements ConsoleArea.Appearance {
        private final Luwrain luwrain;
        private final Strings strings;

        Appearance(Luwrain luwrain, Strings strings) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            NullCheck.notNull((Object)strings, (String)"strings");
            this.luwrain = luwrain;
            this.strings = strings;
        }

        public void announceItem(Object item) {
            NullCheck.notNull((Object)item, (String)"item");
            if (item instanceof UserFull) {
                UserFull user = (UserFull)item;
                Object extInfo = this.getExtInfo(user);
                if (user.getLastSeen() != null) {
                    Date date = new Date(user.getLastSeen().getTime().longValue() * 1000L);
                    extInfo = (String)extInfo + ", " + this.strings.lastSeen(this.luwrain.i18n().getPastTimeBrief(date));
                }
                this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)(user.getFirstName() + " " + user.getLastName() + (String)extInfo), null));
                return;
            }
            this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)item.toString(), null));
        }

        public String getTextAppearance(Object item) {
            NullCheck.notNull((Object)item, (String)"item");
            if (item instanceof UserFull) {
                UserFull user = (UserFull)item;
                return user.getFirstName() + " " + user.getLastName() + this.getExtInfo(user);
            }
            return item.toString();
        }

        private String getExtInfo(UserFull user) {
            NullCheck.notNull((Object)user, (String)"user");
            StringBuilder b = new StringBuilder();
            if (user.getCity() != null && user.getCity().getTitle() != null && !user.getCity().getTitle().trim().isEmpty()) {
                b.append(", ").append(user.getCity().getTitle().trim());
            }
            if (user.getStatus() != null && !user.getStatus().trim().isEmpty()) {
                b.append(", ").append(user.getStatus().trim());
            }
            return new String(b);
        }
    }
}

