/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.httpclient.HttpTransportClient;
import com.vk.api.sdk.objects.messages.ConversationWithMessage;
import com.vk.api.sdk.objects.users.UserFull;
import com.vk.api.sdk.objects.users.UserSettingsXtr;
import com.vk.api.sdk.objects.wall.WallpostFull;
import com.vk.api.sdk.oneofs.NewsfeedNewsfeedItemOneOf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.vk.Settings;
import org.luwrain.app.vk.Strings;
import org.luwrain.app.vk2.AuthLayout;
import org.luwrain.app.vk2.BirthdayUtils;
import org.luwrain.app.vk2.HomeWallLayout;
import org.luwrain.app.vk2.MainLayout;
import org.luwrain.app.vk2.Operations;
import org.luwrain.app.vk2.PersonalInfoLayout;
import org.luwrain.app.vk2.SuggestionsLayout;
import org.luwrain.app.vk2.Watching;
import org.luwrain.app.vk2.layouts.ChatsLayout;
import org.luwrain.app.vk2.layouts.FriendsLayout;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;

public final class App
extends AppBase<Strings> {
    static final String LOG_COMPONENT = "vk";
    public static final InputEvent HOT_KEY_MAIN_LAYOUT = new InputEvent(InputEvent.Special.F5);
    public static final InputEvent HOT_KEY_CHATS = new InputEvent(InputEvent.Special.F6);
    public static final InputEvent HOT_KEY_FRIENDS = new InputEvent(InputEvent.Special.F7);
    public static final InputEvent HOT_KEY_FRIENDSHIP_SUGGESTIONS = new InputEvent(InputEvent.Special.F7, EnumSet.of(InputEvent.Modifiers.ALT));
    public static final InputEvent HOT_KEY_HOME_WALL = new InputEvent(InputEvent.Special.F9);
    public static final InputEvent HOT_KEY_PERSONAL_INFO = new InputEvent(InputEvent.Special.F10, EnumSet.of(InputEvent.Modifiers.ALT));
    public final ArrayList<UserFull> friends = new ArrayList();
    public final ArrayList<UserFull> frRequests = new ArrayList();
    final BirthdayUtils birthdayUtils = new BirthdayUtils(this);
    public final List<WallpostFull> homeWallPosts = new ArrayList<WallpostFull>();
    public final List<ConversationWithMessage> chats = new ArrayList<ConversationWithMessage>();
    final List<NewsfeedNewsfeedItemOneOf> news = new ArrayList<NewsfeedNewsfeedItemOneOf>();
    final ConcurrentMap<Integer, UserFull> userCache = new ConcurrentHashMap<Integer, UserFull>();
    final Watching watching;
    final VkApiClient vk = new VkApiClient((TransportClient)new HttpTransportClient());
    private UserActor actor = null;
    private Settings sett = null;
    private Operations operations = null;
    private AuthLayout authLayout = null;
    private MainLayout mainLayout = null;
    private HomeWallLayout homeWallLayout = null;
    private ChatsLayout chatsLayout = null;
    private FriendsLayout friendsLayout = null;

    public App(Watching watching) {
        super(Strings.class, "luwrain.vk");
        NullCheck.notNull((Object)watching, (String)"watching");
        this.watching = watching;
    }

    protected AreaLayout onAppInit() {
        this.sett = Settings.create(this.getLuwrain());
        this.authLayout = new AuthLayout(this);
        this.mainLayout = new MainLayout(this);
        this.homeWallLayout = new HomeWallLayout(this);
        this.chatsLayout = new ChatsLayout(this);
        this.friendsLayout = new FriendsLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        if (this.sett.getUserId(-1) == -1 || this.sett.getAccessToken("").isEmpty()) {
            return this.authLayout.getAreaLayout();
        }
        this.openInitial();
        return this.mainLayout.getAreaLayout();
    }

    private void openInitial() {
        this.actor = new UserActor(Integer.valueOf(this.sett.getUserId(0)), this.sett.getAccessToken(""));
        this.operations = new Operations(this);
        TaskCancelling.TaskId taskId = this.newTaskId();
        this.runTask(taskId, () -> {
            List<NewsfeedNewsfeedItemOneOf> n = this.operations.getNews();
            List<ConversationWithMessage> c = this.operations.getChats();
            this.finishedTask(taskId, () -> {
                this.news.addAll(n);
                this.chats.addAll(c);
                this.mainLayout.chatsArea.refresh();
            });
        });
    }

    void onAuth(int userId, String accessToken) {
        this.sett.setUserId(userId);
        this.sett.setAccessToken(accessToken);
        this.openInitial();
        this.setAreaLayout(this.mainLayout);
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public void onAppClose() {
    }

    String getUserCommonName(int userId) {
        if (userId < 0 || !this.userCache.containsKey(userId)) {
            return String.valueOf(userId);
        }
        UserFull user = (UserFull)this.userCache.get(new Integer(userId));
        return user.getFirstName() + " " + user.getLastName();
    }

    boolean newFriendship(UserFull user) {
        if (user == null) {
            return false;
        }
        TaskCancelling.TaskId taskId = this.newTaskId();
        return this.runTask(taskId, () -> {
            this.operations.newFriendship(user.getId());
            this.finishedTask(taskId, () -> this.getLuwrain().playSound(Sounds.OK));
        });
    }

    Layouts layouts() {
        return new Layouts(){

            @Override
            public boolean main() {
                App.this.setAreaLayout(App.this.mainLayout);
                App.this.getLuwrain().announceActiveArea();
                return true;
            }

            @Override
            public boolean homeWall() {
                TaskCancelling.TaskId taskId = App.this.newTaskId();
                return App.this.runTask(taskId, () -> {
                    List<WallpostFull> posts = App.this.operations.getWallPosts();
                    App.this.finishedTask(taskId, () -> {
                        App.this.homeWallPosts.clear();
                        App.this.homeWallPosts.addAll(posts);
                        App.this.homeWallLayout.wallArea.refresh();
                        App.this.setAreaLayout(App.this.homeWallLayout);
                    });
                });
            }

            @Override
            public boolean chats() {
                App.this.setAreaLayout(App.this.chatsLayout);
                return true;
            }

            @Override
            public boolean friends() {
                TaskCancelling.TaskId taskId = App.this.newTaskId();
                return App.this.runTask(taskId, () -> {
                    List<UserFull> f = App.this.operations.getFriends(null);
                    App.this.finishedTask(taskId, () -> {
                        App.this.friends.clear();
                        App.this.friends.addAll(f);
                        App.this.friendsLayout.friendsArea.refresh();
                        App.this.setAreaLayout(App.this.friendsLayout);
                    });
                });
            }

            @Override
            public boolean friendshipSuggestions() {
                TaskCancelling.TaskId taskId = App.this.newTaskId();
                return App.this.runTask(taskId, () -> {
                    List<UserFull> f = App.this.operations.getFriendshipSuggestions();
                    App.this.finishedTask(taskId, () -> {
                        SuggestionsLayout layout = new SuggestionsLayout(App.this, f);
                        App.this.setAreaLayout(layout);
                        App.this.getLuwrain().announceActiveArea();
                    });
                });
            }

            @Override
            public boolean personalInfo() {
                TaskCancelling.TaskId taskId = App.this.newTaskId();
                return App.this.runTask(taskId, () -> {
                    UserSettingsXtr i = App.this.operations.getPersonalInfo();
                    String s = App.this.operations.getStatus();
                    App.this.finishedTask(taskId, () -> {
                        PersonalInfoLayout layout = new PersonalInfoLayout(App.this, i, s);
                        App.this.setAreaLayout(layout);
                    });
                });
            }
        };
    }

    UserActor getActor() {
        return this.actor;
    }

    public Operations getOperations() {
        return this.operations;
    }

    static interface Layouts {
        public boolean main();

        public boolean homeWall();

        public boolean chats();

        public boolean friends();

        public boolean friendshipSuggestions();

        public boolean personalInfo();
    }
}

