/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import com.google.gson.JsonArray;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.objects.messages.responses.GetLongPollServerResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.luwrain.app.vk2.WatchingListener;
import org.luwrain.app.vk2.api.GetLongPollEventsQuery;
import org.luwrain.app.vk2.api.GetLongPollEventsResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

public final class Watch
implements Runnable {
    private static final String LOG_COMPONENT = "vk";
    private static final int WAIT_TIME = 20;
    private final Luwrain luwrain;
    final int userId;
    final VkApiClient vk;
    final UserActor actor;
    final List<WatchingListener> listeners = new ArrayList<WatchingListener>();

    Watch(Luwrain luwrain, int userId, VkApiClient vk, UserActor actor) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)vk, (String)LOG_COMPONENT);
        NullCheck.notNull((Object)actor, (String)"actor");
        this.luwrain = luwrain;
        this.userId = userId;
        this.vk = vk;
        this.actor = actor;
    }

    private void onMessage(int messageId, int peerId, String messageText) {
        for (WatchingListener l : this.listeners) {
            l.onMessage(messageId, peerId, messageText);
        }
        this.luwrain.announcement(messageText, Luwrain.AnnouncementType.CHAT, LOG_COMPONENT, "message", null);
    }

    @Override
    public void run() {
        while (true) {
            try {
                GetLongPollServerResponse params = (GetLongPollServerResponse)this.vk.messages().getLongPollServer(this.actor).needPts(Boolean.valueOf(true)).execute();
                Integer ts = params.getTs();
                block5: while (true) {
                    GetLongPollEventsQuery query = new GetLongPollEventsQuery(this.vk, "https://" + params.getServer(), params.getKey(), ts);
                    GetLongPollEventsResponse resp = (GetLongPollEventsResponse)query.waitTime(20).execute();
                    ts = resp.getTs();
                    List<JsonArray> updates = resp.getUpdates();
                    List<JsonArray> objs = resp.getUpdates();
                    Iterator<JsonArray> iterator = objs.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block5;
                        JsonArray a = iterator.next();
                        if (a.size() == 0 || a.get(0).getAsInt() != 4 || a.size() < 7) continue;
                        int messageId = a.get(1).getAsInt();
                        int peerId = a.get(3).getAsInt();
                        String messageText = a.get(6).getAsString();
                        if (messageId < 0 || peerId < 0 || messageText == null) continue;
                        this.onMessage(messageId, peerId, messageText);
                    }
                    break;
                }
            }
            catch (ApiException | ClientException e) {
                e.printStackTrace();
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ee) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            break;
        }
    }
}

