/*
 * Decompiled with CFR 0.152.
 */
package speechd.ssip;

import java.util.HashMap;
import java.util.Map;
import speechd.ssip.SSIPEvent;
import speechd.ssip.SSIPResponse;

public final class SSIPEventParser {
    private static SSIPEventParser _instance = null;
    private static Map<Integer, SSIPEvent.EventType> _eventCodes = new HashMap<Integer, SSIPEvent.EventType>();

    private SSIPEventParser() {
    }

    static SSIPEventParser getInstance() {
        if (_instance == null) {
            _instance = new SSIPEventParser();
        }
        return _instance;
    }

    SSIPEvent parse(SSIPResponse response) {
        assert (response.getData().size() == 2 || response.getData().size() == 3);
        SSIPEvent.EventType type = _eventCodes.get(response.getCode());
        assert (type != null);
        int msgId = Integer.parseInt(response.getData().get(0));
        int clientId = Integer.parseInt(response.getData().get(1));
        if (type == SSIPEvent.EventType.INDEX_MARK) {
            return new SSIPEvent(type, msgId, clientId, response.getData().get(2));
        }
        return new SSIPEvent(type, msgId, clientId);
    }

    static {
        _eventCodes.put(700, SSIPEvent.EventType.INDEX_MARK);
        _eventCodes.put(701, SSIPEvent.EventType.BEGIN);
        _eventCodes.put(702, SSIPEvent.EventType.END);
        _eventCodes.put(703, SSIPEvent.EventType.CANCEL);
        _eventCodes.put(704, SSIPEvent.EventType.PAUSE);
        _eventCodes.put(705, SSIPEvent.EventType.RESUME);
    }
}

