/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander.fileops;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.luwrain.app.commander.fileops.Operation;
import org.luwrain.app.commander.fileops.OperationListener;
import org.luwrain.core.NullCheck;

public final class ZipCompress
extends Operation {
    private final Path[] toCompress;
    private final Path zipFile;
    private ZipOutputStream zip = null;

    public ZipCompress(OperationListener listener, String name, Path[] toCompress, Path zipFile) {
        super(listener, name);
        ZipCompress.ensureValidLocalPath(toCompress);
        ZipCompress.ensureValidLocalPath(zipFile);
        this.toCompress = toCompress;
        this.zipFile = zipFile;
    }

    @Override
    protected void work() throws IOException {
        try (OutputStream os = Files.newOutputStream(this.zipFile, new OpenOption[0]);
             ZipOutputStream zip = new ZipOutputStream(os);){
            this.zip = zip;
            for (Path p : this.toCompress) {
                this.add(p);
            }
        }
    }

    private void add(Path path) throws IOException {
        NullCheck.notNull((Object)path, (String)"path");
        if (Files.isSymbolicLink(path)) {
            return;
        }
        if (ZipCompress.isRegularFile(path, false)) {
            this.addFile(path);
            return;
        }
        for (Path p : ZipCompress.getDirContent(path)) {
            this.add(p);
        }
    }

    private void addFile(Path file) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            ZipEntry zipEntry = new ZipEntry(file.toString());
            this.zip.putNextEntry(zipEntry);
            IOUtils.copy((InputStream)is, (OutputStream)this.zip);
        }
    }

    @Override
    public int getPercent() {
        return 0;
    }
}

