/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.lsocial;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.lsocial.Config;
import org.luwrain.app.lsocial.Conv;
import org.luwrain.app.lsocial.MainLayout;
import org.luwrain.app.lsocial.Strings;
import org.luwrain.core.AreaLayout;
import org.luwrain.io.api.yandex_gpt.CompletionOptions;
import org.luwrain.io.api.yandex_gpt.Message;
import org.luwrain.io.api.yandex_gpt.Response;
import org.luwrain.io.api.yandex_gpt.ResultAlternative;
import org.luwrain.io.api.yandex_gpt.YandexGpt;
import org.luwrain.util.TextUtils;

public final class App
extends AppBase<Strings> {
    public static final String ENDPOINT = "https://luwrain.social";
    public Conv conv = null;
    public Config conf = null;
    private MainLayout mainLayout = null;
    private Set<String> nbspAfterWords = new HashSet<String>(Arrays.asList("\u0412", "\u041d\u0410", "\u041f\u041e\u0414"));

    public App() {
        super(Strings.class, "luwrain.commander");
    }

    public AreaLayout onAppInit() {
        this.conf = (Config)this.getLuwrain().loadConf(Config.class);
        if (this.conf == null) {
            this.conf = new Config();
            this.getLuwrain().saveConf((Object)this.conf);
        }
        this.conv = new Conv(this);
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        if (!Objects.requireNonNull(this.conf.getAccessToken(), "").trim().isEmpty()) {
            this.mainLayout.updateMainList();
        }
        return this.mainLayout.getAreaLayout();
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    List<String> yandexGpt(String query) throws IOException {
        List<Message> messages = List.of(new Message("user", query));
        YandexGpt g = new YandexGpt(this.conf.getYandexFolderId(), this.conf.getYandexApiKey(), new CompletionOptions(false, 0.7, 4096), messages);
        Response resp = g.doSync();
        List a = resp.getResult().getAlternatives();
        return Arrays.asList(((ResultAlternative)a.get(0)).getMessage().getText().split("\n", -1));
    }

    public String translateUserInput(String line, int pos, String text) {
        String lastWord = TextUtils.getLastWord((String)line, (int)pos).toUpperCase();
        if (text.equals(" ") && this.nbspAfterWords.contains(lastWord)) {
            return "~";
        }
        return text;
    }
}

