/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.wifi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.wifi.Conv;
import org.luwrain.app.wifi.MainLayout;
import org.luwrain.app.wifi.Strings;
import org.luwrain.core.Application;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.MonoApp;
import org.luwrain.core.Sounds;
import org.luwrain.linux.WifiNetwork;
import org.luwrain.linux.services.NmCli;

public final class App
extends AppBase<Strings>
implements MonoApp {
    final List<WifiNetwork> networks = new ArrayList<WifiNetwork>();
    final NmCli nmCli = new NmCli();
    private MainLayout mainLayout = null;
    private Conv conv = null;

    public App() {
        super("luwrain.wifi", Strings.class, "luwrain.linux.wifi");
    }

    protected AreaLayout onAppInit() {
        this.conv = new Conv(this);
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        this.updateNetworkList();
        return this.mainLayout.getAreaLayout();
    }

    boolean updateNetworkList() {
        TaskCancelling.TaskId taskId = this.newTaskId();
        return this.runTask(taskId, () -> {
            WifiNetwork[] n = this.nmCli.scan();
            this.finishedTask(taskId, () -> {
                this.networks.clear();
                this.networks.addAll(Arrays.asList(n));
                if (this.mainLayout != null) {
                    this.mainLayout.networksArea.refresh();
                }
                this.getLuwrain().playSound(Sounds.DONE);
            });
        });
    }

    void updateNetworksSync() throws Exception {
        WifiNetwork[] n = this.nmCli.scan();
        this.networks.clear();
        this.networks.addAll(Arrays.asList(n));
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public MonoApp.Result onMonoAppSecondInstance(Application app) {
        return MonoApp.Result.BRING_FOREGROUND;
    }

    Conv getConv() {
        return this.conv;
    }
}

