/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.FutureTask;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.linux.Linux;

final class FifoInputListening {
    private static final String LOG_COMPONENT = "linux";
    private static final String COMMAND_PREFIX = "command ";
    private static final String USB_DISK_ATTACHED_PREFIX = "usbdiskattached ";
    private static final String CDROM_CHANGED_PREFIX = "cdromchanged ";
    private static final String UNIREF_PREFIX = "uniref ";
    private final Luwrain luwrain;
    private final Linux linux;
    private final String fileName;
    private FutureTask task = null;

    FifoInputListening(Luwrain luwrain, Linux linux, String fileName) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)linux, (String)LOG_COMPONENT);
        NullCheck.notEmpty((Object)fileName, (String)"fileName");
        this.luwrain = luwrain;
        this.linux = linux;
        this.fileName = fileName;
    }

    void run() {
        this.task = this.createTask();
        Log.debug((String)LOG_COMPONENT, (String)("starting fifo input listening on " + this.fileName));
        this.luwrain.executeBkg((Runnable)this.task);
    }

    private FutureTask createTask() {
        return new FutureTask<Object>(() -> {
            BufferedReader reader = null;
            FileOutputStream output = null;
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName)));
                output = new FileOutputStream(this.fileName);
                String line = null;
                do {
                    if ((line = reader.readLine()) == null) continue;
                    this.processLine(line);
                } while (line != null);
            }
            catch (Exception e) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.error((String)LOG_COMPONENT, (String)("unable to get pointer input events:" + e.getClass().getName() + ":" + e.getMessage()));
            }
        }, null);
    }

    private void processLine(String line) {
        NullCheck.notNull((Object)line, (String)"line");
        if (line.startsWith(COMMAND_PREFIX)) {
            String command = line.substring(COMMAND_PREFIX.length()).trim();
            if (!command.isEmpty()) {
                this.luwrain.runUiSafely(() -> this.luwrain.runCommand(command));
            }
            return;
        }
        if (line.startsWith(UNIREF_PREFIX)) {
            String uniref = line.substring(UNIREF_PREFIX.length()).trim();
            if (!uniref.isEmpty()) {
                this.luwrain.runUiSafely(() -> this.luwrain.openUniRef(uniref));
            }
            return;
        }
    }
}

