/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import com.google.auto.service.AutoService;
import java.nio.file.Path;
import org.luwrain.core.Braille;
import org.luwrain.core.InitResult;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.core.OperatingSystem;
import org.luwrain.core.PropertiesBase;
import org.luwrain.interaction.KeyboardHandler;
import org.luwrain.linux.BashProcess;
import org.luwrain.linux.BrlApi;
import org.luwrain.linux.Extension;
import org.luwrain.linux.KeyboardJavafxHandler;
import org.luwrain.linux.Syscalls;

@AutoService(value={OperatingSystem.class})
public final class Linux
implements OperatingSystem {
    public static final String LOG_COMPONENT = "linux";
    public static final Syscalls syscalls = new Syscalls();
    private PropertiesBase props = null;

    public InitResult init(PropertiesBase props) {
        Extension.setLinux(this);
        this.props = props;
        return new InitResult();
    }

    public String escapeString(String style, String value) {
        switch (style.trim().toUpperCase()) {
            case "CMD": 
            case "SHELL": 
            case "BASH": {
                return BashProcess.escape(value);
            }
        }
        Log.warning((String)LOG_COMPONENT, (String)("unknown escaping style: " + style));
        return value;
    }

    public String getProperty(String propName) {
        NullCheck.notNull((Object)propName, (String)"propName");
        return "";
    }

    public Braille getBraille() {
        return new BrlApi();
    }

    public void openFileInDesktop(Path path) {
        throw new UnsupportedOperationException("Linux has no support of opening files in desktop environment");
    }

    public KeyboardHandler getCustomKeyboardHandler(String subsystem) {
        NullCheck.notNull((Object)subsystem, (String)"subsystem");
        switch (subsystem.toLowerCase().trim()) {
            case "javafx": {
                return new KeyboardJavafxHandler();
            }
        }
        return null;
    }

    PropertiesBase getProps() {
        return this.props;
    }
}

