/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.inlandes.Matcher;
import org.luwrain.inlandes.ReplacementToken;
import org.luwrain.inlandes.ScriptEngine;
import org.luwrain.inlandes.Token;
import org.luwrain.inlandes.operations.ScriptObjectToken;

public class GraalVmEngine
implements ScriptEngine {
    private final Context context;

    public GraalVmEngine() {
        Engine engine = Engine.newBuilder().option("engine.WarnInterpreterOnly", "false").build();
        this.context = Context.newBuilder((String[])new String[]{"js"}).engine(engine).allowExperimentalOptions(true).build();
        this.context.getBindings("js").putMember("Inlandes", (Object)new InlandesObj());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String text, Map<String, Object> bindings) {
        Value b = this.context.getBindings("js");
        try {
            for (Map.Entry<String, Object> e : bindings.entrySet()) {
                b.putMember(e.getKey(), e.getValue());
            }
            Value value = this.context.eval("js", (CharSequence)text);
            return value;
        }
        finally {
            for (Map.Entry<String, Object> e : bindings.entrySet()) {
                b.removeMember(e.getKey());
            }
        }
    }

    @Override
    public Map<String, Object> createBindings(Token[] tokens, Matcher.Matching matching) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (int i = 0; i < 10; ++i) {
            int refEnd;
            int refBegin = matching.getRefBegin(i);
            if (refBegin == (refEnd = matching.getRefEnd(i))) continue;
            if (refEnd > refBegin + 1) {
                res.put("_" + String.valueOf(i), Token.concatText(Arrays.copyOfRange(tokens, refBegin, refEnd)));
                continue;
            }
            res.put("_" + String.valueOf(i), this.createBindingObj(tokens[refBegin]));
        }
        return res;
    }

    @Override
    public void close() {
        this.context.close();
    }

    @Override
    public boolean isObjWithTrueValue(Object obj, String valueName) {
        if (obj == null) {
            throw new NullPointerException("obj can't be null");
        }
        if (valueName == null) {
            throw new NullPointerException("valueName can't be null");
        }
        if (valueName.isEmpty()) {
            throw new IllegalArgumentException("valueName can't be empty");
        }
        if (obj instanceof Value) {
            Value value = (Value)obj;
            if (!value.hasMembers()) {
                return false;
            }
            Value v = value.getMember(valueName);
            if (v == null || v.isNull() || !v.isBoolean()) {
                return false;
            }
            return v.asBoolean();
        }
        if (obj instanceof ScriptObjectToken) {
            ScriptObjectToken token = (ScriptObjectToken)obj;
            return this.isObjWithTrueValue(token.obj, valueName);
        }
        if (obj instanceof ReplacementToken) {
            ReplacementToken token = (ReplacementToken)obj;
            return this.isObjWithTrueValue(token.token, valueName);
        }
        return false;
    }

    private Object createBindingObj(Token token) {
        if (token instanceof ScriptObjectToken) {
            return (Value)((ScriptObjectToken)token).obj;
        }
        if (token instanceof ReplacementToken) {
            return this.createBindingObj(((ReplacementToken)token).token);
        }
        return token.getText();
    }

    public static final class InlandesObj {
        @HostAccess.Export
        public ProxyExecutable getRomanNum = this::getRomanNumImpl;

        public Object getRomanNumImpl(Value[] args) {
            return new Integer(5);
        }
    }
}

