/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.inlandes.RuleStatement;
import org.luwrain.inlandes.Token;
import org.luwrain.inlandes.WhereIterator;

public final class Matcher {
    public static final int REF_NUM = 10;
    public static final int NO_REF = -1;
    private final RuleStatement[] rules;
    private final List<Matching> matchings = new ArrayList<Matching>();
    private ArrayList<WhereIterator> current = null;
    private ArrayList<WhereIterator> next = null;
    Token token = null;
    int tokenIndex = -1;

    public Matcher(RuleStatement[] rules) {
        if (rules == null) {
            throw new NullPointerException("rules can't be null");
        }
        this.rules = (RuleStatement[])rules.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Matching> match(Token[] tokens) {
        this.matchings.clear();
        try {
            this.current = new ArrayList();
            this.next = new ArrayList();
            ArrayList<Object> a = new ArrayList();
            this.tokenIndex = 0;
            while (this.tokenIndex < tokens.length) {
                if (!this.current.isEmpty()) {
                    throw new IllegalStateException("The list of the current iterators must be empty before checking of new token");
                }
                if (!this.next.isEmpty()) {
                    throw new IllegalStateException("The list of the next iterators must be empty before checking of new token");
                }
                this.token = tokens[this.tokenIndex];
                for (RuleStatement r : this.rules) {
                    if (r.getWhere() == null) continue;
                    a.add(new WhereIterator(this, r));
                }
                while (!a.isEmpty()) {
                    for (WhereIterator whereIterator : a) {
                        whereIterator.check();
                    }
                    a = this.current;
                    this.current = new ArrayList();
                    this.current.ensureCapacity(a.size());
                }
                a = this.next;
                this.next = new ArrayList();
                this.next.ensureCapacity(a.size());
                ++this.tokenIndex;
            }
            for (WhereIterator whereIterator : a) {
                whereIterator.onFinishing();
            }
        }
        finally {
            this.token = null;
            this.tokenIndex = -1;
            this.current = null;
            this.next = null;
        }
        return this.matchings;
    }

    public Matching[] matchAsArray(Token[] tokens) {
        List<Matching> res = this.match(tokens);
        return res.toArray(new Matching[res.size()]);
    }

    void addCurrentPos(WhereIterator it) {
        if (it == null) {
            throw new NullPointerException("it can't be null");
        }
        this.current.add(it);
    }

    void addNextPos(WhereIterator it) {
        if (it == null) {
            throw new NullPointerException("it can't be null");
        }
        this.next.add(it);
    }

    void success(WhereIterator it, RuleStatement rule, int[] refsBegin, int[] refsEnd) {
        refsEnd[0] = this.tokenIndex;
        this.matchings.add(new Matching(rule, refsBegin, refsEnd));
    }

    public static final class Matching {
        private final RuleStatement rule;
        private final int[] refsBegin;
        private final int[] refsEnd;
        final int rangeFrom;
        final int rangeTo;
        final int len;

        Matching(RuleStatement rule, int[] refsBegin, int[] refsEnd) {
            if (rule == null) {
                throw new NullPointerException("rule can't be null");
            }
            this.rule = rule;
            this.refsBegin = (int[])refsBegin.clone();
            this.refsEnd = (int[])refsEnd.clone();
            this.rangeFrom = refsBegin[0];
            this.rangeTo = refsEnd[0];
            this.len = this.rangeTo - this.rangeFrom;
            if (this.len < 0) {
                throw new IllegalArgumentException("Illegal range of the matching");
            }
        }

        public RuleStatement getRule() {
            return this.rule;
        }

        public int getRefBegin(int refIndex) {
            if (refIndex < 0) {
                throw new IllegalArgumentException("refIndex can't be negative");
            }
            if (refIndex >= 10) {
                throw new IllegalArgumentException("refIndex can't be greater than 9");
            }
            return this.refsBegin[refIndex];
        }

        public int getRefEnd(int refIndex) {
            if (refIndex < 0) {
                throw new IllegalArgumentException("refIndex can't be negative");
            }
            if (refIndex >= 10) {
                throw new IllegalArgumentException("refIndex can't be greater than 9");
            }
            return this.refsEnd[refIndex];
        }

        public boolean overlaps(Matching m) {
            if (this.len == 0 || m.len == 0) {
                return false;
            }
            if (this.inside(m.rangeFrom) || this.inside(m.rangeTo - 1)) {
                return true;
            }
            return m.inside(this.rangeFrom) || m.inside(this.rangeTo - 1);
        }

        private boolean inside(int pos) {
            return pos >= this.rangeFrom && pos < this.rangeTo;
        }
    }
}

