/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.translate;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.translate.App;
import org.luwrain.app.translate.Strings;
import org.luwrain.app.translate.layouts.OptionsLayout;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.io.api.yandex.translate.YandexTranslate;
import org.luwrain.io.api.yandex.translate.model.Request;
import org.luwrain.io.api.yandex.translate.model.Response;
import org.luwrain.io.api.yandex.translate.model.Translation;
import org.luwrain.util.LineIterator;

final class MainLayout
extends LayoutBase {
    private static final Logger log = LogManager.getLogger();
    final EditArea firstArea;
    final EditArea secondArea;
    final App app;

    MainLayout(App app) {
        super((AppBase)app);
        Strings s = (Strings)app.getStrings();
        this.app = app;
        this.firstArea = new EditArea(this.editParams(p -> {
            p.name = s.firstLangAreaName();
        })){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case OK: {
                        return MainLayout.this.translate(true);
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.secondArea = new EditArea(this.editParams(p -> {
            p.name = s.secondLangAreaName();
        })){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case OK: {
                        return MainLayout.this.translate(false);
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.setPropertiesHandler((Area)this.firstArea, a -> new OptionsLayout(app, this.getReturnAction()));
        this.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.firstArea, null, (Area)this.secondArea, null);
    }

    boolean translate(boolean fromFirstArea) {
        List text = fromFirstArea ? this.firstArea.getTextAsList() : this.secondArea.getTextAsList();
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            Request req = new Request(this.app.yandexConf.getTranslatorFolderId(), "en", List.of(text.stream().collect(Collectors.joining("\n"))));
            YandexTranslate t = new YandexTranslate(this.app.yandexConf.getTranslatorApiKey());
            Response resp = t.request(req);
            this.app.finishedTask(taskId, () -> {
                EditArea targetArea;
                EditArea editArea = targetArea = fromFirstArea ? this.secondArea : this.firstArea;
                if (resp != null && resp.getTranslations() != null && !resp.getTranslations().isEmpty()) {
                    targetArea.update((lines, hotPoint) -> {
                        lines.clear();
                        for (Translation tr : resp.getTranslations()) {
                            try {
                                LineIterator it = new LineIterator(Objects.requireNonNullElse(tr.getText(), ""));
                                while (it.hasNext()) {
                                    lines.add(it.next());
                                }
                                lines.add("");
                            }
                            catch (IOException ex) {
                                this.app.crash(ex);
                            }
                        }
                        return true;
                    });
                } else {
                    targetArea.clear();
                }
                this.setActiveArea((Area)targetArea);
                this.getLuwrain().playSound(Sounds.DONE);
            });
        });
    }
}

