/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.browser;

import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.browser.App;
import org.luwrain.app.browser.Strings;
import org.luwrain.app.browser.TestBlocks;
import org.luwrain.app.browser.WebLine;
import org.luwrain.app.browser.layouts.InfoLayout;
import org.luwrain.controls.block.Block;
import org.luwrain.controls.block.BlockArea;
import org.luwrain.controls.block.BlockLine;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.graphical.FxThread;

final class MainLayout
extends LayoutBase {
    final App app;
    final BlockArea webArea;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        BlockArea.Params params = new BlockArea.Params();
        params.context = this.getControlContext();
        params.appearance = new Appearance();
        this.webArea = new BlockArea(params){

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case PROPERTIES: {
                            return MainLayout.this.onShowInfo();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.webArea.setBlocks(TestBlocks.getTestBlocks());
        this.setAreaLayout(this.webArea, this.actions(new LayoutBase.ActionInfo[]{this.action("open-url", ((Strings)app.getStrings()).actionOpenUrl(), new InputEvent(InputEvent.Special.F6), this::actOpenUrl), this.action("show-graphical", ((Strings)app.getStrings()).actionShowGraphical(), new InputEvent(InputEvent.Special.F10), this::actShowGraphical)}));
    }

    private boolean actOpenUrl() {
        String url = this.app.getConv().openUrl("https://");
        if (url == null) {
            return false;
        }
        FxThread.runSync(() -> this.app.getEngine().load(url));
        return true;
    }

    private boolean onShowInfo() {
        InfoLayout infoLayout = new InfoLayout(this.app, () -> {
            this.app.setAreaLayout(this);
            this.getLuwrain().announceActiveArea();
            return true;
        });
        this.app.setAreaLayout(infoLayout);
        this.getLuwrain().announceActiveArea();
        return true;
    }

    private boolean actShowGraphical() {
        this.getLuwrain().showGraphical(graphicalModeControl -> {
            this.app.getView().setOnKeyReleased(event -> {
                switch (event.getCode()) {
                    case ESCAPE: {
                        this.app.getLuwrain().runUiSafely(() -> this.app.getLuwrain().playSound(Sounds.OK));
                        graphicalModeControl.close();
                    }
                }
            });
            this.app.getView().setVisible(true);
            return this.app.getView();
        });
        return true;
    }

    private final class Appearance
    implements BlockArea.Appearance {
        private Appearance() {
        }

        @Override
        public void announceFirstBlockLine(Block block, BlockLine blockLine) {
            WebLine webLine = (WebLine)blockLine;
            MainLayout.this.app.setEventResponse(DefaultEventResponse.text((String)webLine.text));
        }

        @Override
        public void announceBlockLine(Block block, BlockLine blockLine) {
            WebLine webLine = (WebLine)blockLine;
            MainLayout.this.app.setEventResponse(DefaultEventResponse.text((String)webLine.text));
        }

        @Override
        public String getBlockLineTextAppearance(Block block, BlockLine blockLine) {
            WebLine webLine = (WebLine)blockLine;
            return webLine.text;
        }
    }
}

