/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.webinspector;

import com.sun.webkit.dom.TextImpl;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.luwrain.app.webinspector.WebTree;
import org.luwrain.core.NullCheck;
import org.luwrain.graphical.FxThread;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

final class WebObject {
    final WebTree tree;
    final Node node;
    final Element el;
    final String tagName;
    final String text;

    WebObject(WebTree tree, Node node) {
        NullCheck.notNull((Object)tree, (String)"tree");
        NullCheck.notNull((Object)node, (String)"node");
        FxThread.ensure();
        this.tree = tree;
        this.node = node;
        if (node instanceof Element) {
            this.el = (Element)node;
            this.tagName = this.el.getTagName();
            this.text = null;
        } else if (node instanceof TextImpl) {
            TextImpl textObj = (TextImpl)node;
            this.el = null;
            this.tagName = null;
            this.text = textObj.getWholeText();
        } else {
            this.el = null;
            this.tagName = null;
            this.text = node.getClass().getName();
        }
    }

    WebObject[] getChildren() {
        AtomicBoolean isNull = new AtomicBoolean(false);
        ArrayList res = new ArrayList();
        FxThread.runSync(() -> {
            NodeList items = this.node.getChildNodes();
            if (items == null) {
                isNull.set(true);
                return;
            }
            for (int i = 0; i < items.getLength(); ++i) {
                WebObject newObj = new WebObject(this.tree, items.item(i));
                if (newObj.text != null && newObj.text.trim().isEmpty()) continue;
                res.add(newObj);
            }
        });
        if (isNull.get()) {
            return null;
        }
        return res.toArray(new WebObject[res.size()]);
    }

    boolean hasChildren() {
        return this.node.hasChildNodes();
    }

    CSSStyleDeclaration getStyle() {
        if (this.el == null) {
            return null;
        }
        return this.tree.getStyle(this.el);
    }

    String getStyleAsText() {
        return "";
    }

    public String toString() {
        if (this.tagName != null) {
            return this.tagName;
        }
        return this.text;
    }
}

