/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.block;

import org.luwrain.controls.block.Block;
import org.luwrain.controls.block.BlockArea;
import org.luwrain.controls.block.BlockLine;
import org.luwrain.core.NullCheck;

public final class BlockIterator {
    private final BlockArea blockArea;
    int blockIndex;
    int lineIndex;

    BlockIterator(BlockArea blockArea, int blockIndex, int lineIndex) {
        NullCheck.notNull((Object)blockArea, (String)"blockArea");
        if (blockIndex < 0) {
            throw new IllegalArgumentException("blockIndex (" + blockIndex + ") may not be negative");
        }
        if (lineIndex < 0) {
            throw new IllegalArgumentException("lineIndex (" + lineIndex + ") may not be negative");
        }
        this.blockArea = blockArea;
        this.blockIndex = blockIndex;
        this.lineIndex = lineIndex;
    }

    public BlockIterator(BlockArea blockArea) {
        this(blockArea, 0, 0);
    }

    boolean movePrev() {
        if (this.lineIndex > 0) {
            --this.lineIndex;
            return true;
        }
        if (this.blockIndex > 0) {
            --this.blockIndex;
            this.lineIndex = this.getBlock().getLineCount() - 1;
            return true;
        }
        return false;
    }

    boolean moveNext() {
        if (this.lineIndex + 1 < this.getBlock().getLineCount()) {
            ++this.lineIndex;
            return true;
        }
        if (this.blockIndex + 1 < this.blockArea.blocks.size()) {
            ++this.blockIndex;
            this.lineIndex = 0;
            return true;
        }
        return false;
    }

    public Block getBlock() {
        return this.blockArea.blocks.get(this.blockIndex);
    }

    public int getX() {
        return this.getBlock().getX();
    }

    public int getY() {
        return this.getBlock().getY() + this.lineIndex;
    }

    public BlockLine getLine() {
        return this.getBlock().getLine(this.lineIndex);
    }

    public String getLineText(BlockArea.Appearance appearance) {
        return appearance.getBlockLineTextAppearance(this.getBlock(), this.getLine());
    }
}

