/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.block;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.controls.block.Block;
import org.luwrain.controls.block.BlockArea;
import org.luwrain.core.Lines;
import org.luwrain.core.NullCheck;

public final class View
implements Lines {
    private final BlockArea.Appearance appearance;
    private final ArrayList<Block> blocks = new ArrayList();
    private final ArrayList<String> lines = new ArrayList();

    public View(BlockArea.Appearance appearance, List<Block> blocks) {
        NullCheck.notNull((Object)appearance, (String)"appearance");
        NullCheck.notNull(blocks, (String)"blocks");
        this.appearance = appearance;
        this.blocks.addAll(blocks);
        this.buildLines();
    }

    public int getLineCount() {
        return Math.max(this.lines.size(), 1);
    }

    public String getLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") can't be negative");
        }
        if (index >= this.lines.size()) {
            return "";
        }
        return this.lines.get(index);
    }

    private void buildLines() {
        int width = 0;
        int height = 0;
        for (Block b : this.blocks) {
            width = Math.max(width, b.getX() + b.getWidth());
            height = Math.max(height, b.getY() + b.getLineCount());
        }
        if (width == 0) {
            return;
        }
        Object emptyLine = " ";
        while (((String)emptyLine).length() < width) {
            if (((String)emptyLine).length() * 2 < width) {
                emptyLine = (String)emptyLine + (String)emptyLine;
                continue;
            }
            emptyLine = (String)emptyLine + " ";
        }
        this.lines.ensureCapacity(height);
        while (this.lines.size() < height) {
            this.lines.add((String)emptyLine);
        }
        for (Block b : this.blocks) {
            for (int i = 0; i < b.getLineCount(); ++i) {
                Object line = this.appearance.getBlockLineTextAppearance(b, b.getLine(i));
                if (((String)line).length() > b.getWidth()) {
                    line = ((String)line).substring(0, b.getWidth());
                }
                if (((String)line).length() < b.getWidth()) {
                    line = (String)line + ((String)emptyLine).substring(0, b.getWidth() - ((String)line).length());
                }
                int lineIndex = b.getY() + i;
                String origLine = this.lines.get(lineIndex);
                this.lines.set(lineIndex, origLine.substring(0, b.getX()) + (String)line + origLine.substring(b.getX() + b.getWidth()));
            }
        }
    }
}

