/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.web;

import java.util.Arrays;
import java.util.List;
import org.luwrain.util.RangeUtils;

public final class BlockGeom {
    public final Block[] blocks;
    private final int count;
    private int[][] matrix = null;

    public BlockGeom(List<? extends Block> blocks) {
        this.blocks = blocks.toArray(new Block[blocks.size()]);
        this.count = blocks.size();
    }

    public void process() {
        Arrays.sort(this.blocks);
        this.buildMatrix();
        for (int i = 0; i < this.count; ++i) {
            for (int j = i + 1; j < this.count; ++j) {
                Block b1 = this.blocks[i];
                Block b2 = this.blocks[j];
                int space = this.matrix[i][j];
                if (space < 0) continue;
                b2.top = Math.max(b2.top, b1.top + b1.height + space - 1);
            }
        }
    }

    private void buildMatrix() {
        int j;
        int i;
        this.matrix = new int[this.count][this.count];
        for (i = 0; i < this.count; ++i) {
            for (j = 0; j < this.count; ++j) {
                this.matrix[i][j] = -1;
            }
        }
        for (i = 0; i < this.count; ++i) {
            for (j = i + 1; j < this.count; ++j) {
                Block b1 = this.blocks[i];
                Block b2 = this.blocks[j];
                if (!RangeUtils.intersects((int)b1.left, (int)(b1.right - b1.left), (int)b2.left, (int)(b2.right - b1.left))) continue;
                this.matrix[i][j] = b1.top == b2.top ? 1 : b2.top - b1.top;
                assert (this.matrix[i][j] >= 0);
            }
        }
    }

    public static class Block
    implements Comparable<Block> {
        int left;
        int right;
        int top;
        int height;

        @Override
        public int compareTo(Block b) {
            if (this.top != b.top) {
                return Integer.valueOf(this.top).compareTo(b.top);
            }
            return Integer.valueOf(this.left).compareTo(b.left);
        }
    }
}

