/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.luwrain.util.StreamUtils;
import org.luwrain.util.TextUtils;

final class TextFiles {
    TextFiles() {
    }

    static String readAsString(File file, String charset) throws IOException {
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(charset, "charset can't be null");
        try (FileInputStream is = new FileInputStream(file);){
            String string = new String(StreamUtils.readAllBytes((InputStream)is), charset);
            return string;
        }
    }

    static List<String> read(File file, String charset) throws IOException {
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(charset, "charset can't be null");
        if (charset.isEmpty()) {
            throw new IllegalArgumentException("charset can't be empty");
        }
        return TextUtils.splitLinesAsList((String)TextFiles.readAsString(file, charset));
    }

    static void write(File file, String text, String charset) throws IOException {
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(text, "text can't be null");
        Objects.requireNonNull(charset, "charset can't be null");
        if (charset.isEmpty()) {
            throw new IllegalArgumentException("charset can't be empty");
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            StreamUtils.writeAllBytes((OutputStream)os, (byte[])text.getBytes(charset));
            os.flush();
        }
    }

    static void write(File file, List<String> text, String charset, String lineSep) throws IOException {
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(text, "text can't be null");
        Objects.requireNonNull(charset, "charset can't be null");
        Objects.requireNonNull(lineSep, "lineSep can't be null");
        if (text.isEmpty() || text.size() == 1 && text.get(0).isEmpty()) {
            TextFiles.write(file, "", charset);
            return;
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String i : text) {
            if (!first) {
                b.append(lineSep);
            }
            b.append(i);
            first = false;
        }
        TextFiles.write(file, new String(b), charset);
    }
}

