/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.rhvoice;

import com.github.olga_yakovleva.rhvoice.RHVoiceException;
import com.github.olga_yakovleva.rhvoice.SynthesisParameters;
import com.github.olga_yakovleva.rhvoice.TTSClient;
import com.github.olga_yakovleva.rhvoice.TTSEngine;
import com.github.olga_yakovleva.rhvoice.VoiceInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.NullCheck;
import org.luwrain.extensions.rhvoice.RHVoice;
import org.luwrain.extensions.rhvoice.SpeakingThread;
import org.luwrain.speech.Channel;
import org.luwrain.speech.Voice;

final class Channel
implements org.luwrain.speech.Channel {
    private static final Logger log = LogManager.getLogger();
    private static final double UPPER_CASE_PITCH_MODIFIER = 3.0;
    private static final double RATE_MIN = 0.5;
    private static final double RATE_MAX = 2.0;
    private final TTSEngine tts;
    private final String voiceName;
    private SpeakingThread thread = null;

    Channel(Map<String, String> params) throws Exception {
        Path dataPath = Paths.get("rhvoice", "data");
        Path configPath = Paths.get("rhvoice", "config");
        Path enPath = Paths.get("data", "languages", "English");
        Path ruPath = Paths.get("data", "languages", "Russian");
        log.trace("Data directory: " + dataPath.toString());
        this.tts = new TTSEngine(dataPath.toString(), configPath.toString(), new String[]{enPath.toString(), ruPath.toString()}, (tag, level, message) -> {});
        this.voiceName = params.containsKey("voice") && !params.get("voice").isEmpty() ? params.get("voice") : this.suggestVoice();
        log.trace("Voice name: " + this.voiceName);
        if (this.voiceName == null || this.voiceName.trim().isEmpty()) {
            throw new Exception("Unable to get suitable voice name");
        }
    }

    public String getChannelName() {
        return "RHVoice";
    }

    private String suggestVoice() {
        String voiceRu = null;
        String voiceEn = null;
        List voices = this.tts.getVoices();
        for (VoiceInfo voice : voices) {
            if (voiceRu == null && voice.getLanguage().getName().equals("Russian")) {
                voiceRu = voice.getName();
            }
            if (voiceEn != null || !voice.getLanguage().getName().equals("English")) continue;
            voiceEn = voice.getName();
        }
        if (voiceRu == null && voiceEn == null) {
            log.warn("no voices neither Russian nor English");
            return "";
        }
        if (voiceRu == null) {
            return voiceEn;
        }
        if (voiceEn == null) {
            return voiceRu;
        }
        return voiceRu + "+" + voiceEn;
    }

    public Voice[] getVoices() {
        Voice[] voices = new Voice[this.tts.getVoices().size()];
        int i = 0;
        for (VoiceInfo voice : this.tts.getVoices()) {
            voices[i++] = new RHVoice(voice.getName());
        }
        return voices;
    }

    public long speak(String text, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        NullCheck.notNull((Object)text, (String)"text");
        SynthesisParameters p = new SynthesisParameters();
        p.setVoiceProfile(this.voiceName);
        p.setRate(Channel.convRate(relRate));
        p.setPitch(Channel.convPitch(relPitch));
        p.setSSMLMode(false);
        this.runThread(text, listener, p);
        return -1L;
    }

    public long speakLetter(char letter, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        SynthesisParameters p = new SynthesisParameters();
        p.setVoiceProfile(this.voiceName);
        p.setRate(Channel.convRate(relRate));
        p.setPitch(Channel.convPitch(relPitch) + (Character.isUpperCase(letter) ? 3.0 : 0.0));
        p.setSSMLMode(false);
        this.runThread("" + letter, listener, p);
        return -1L;
    }

    private void runThread(String text, Channel.Listener listener, SynthesisParameters params) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)params, (String)"params");
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = new SpeakingThread(text, listener, this, params);
        new Thread(this.thread).start();
    }

    public Channel.Result synth(String text, final OutputStream stream, AudioFormat format, Channel.SyncParams params, Set<Channel.Flags> flags) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)stream, (String)"stream");
        NullCheck.notNull((Object)format, (String)"format");
        NullCheck.notNull((Object)params, (String)"params");
        NullCheck.notNull(flags, (String)"flags");
        if (text.trim().isEmpty()) {
            return new Channel.Result();
        }
        SynthesisParameters p = new SynthesisParameters();
        p.setVoiceProfile(this.voiceName);
        p.setRate(Channel.convRate(params.getRate()));
        p.setPitch(Channel.convPitch(params.getPitch()));
        p.setSSMLMode(false);
        try {
            this.tts.speak(text, p, new TTSClient(){

                public boolean setSampleRate(int sampleRate) {
                    return true;
                }

                public boolean playSpeech(short[] samples) {
                    try {
                        ByteBuffer buffer = ByteBuffer.allocate(samples.length * 2);
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        buffer.asShortBuffer().put(samples);
                        byte[] bytes = buffer.array();
                        stream.write(bytes);
                    }
                    catch (IOException e) {
                        log.error("Unable to speak");
                        return false;
                    }
                    return true;
                }
            });
            return new Channel.Result();
        }
        catch (RHVoiceException e) {
            log.error("RHVoice error:", (Throwable)e);
            return new Channel.Result(Channel.Result.Type.FAILED, (Exception)((Object)e));
        }
    }

    public void silence() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    public AudioFormat[] getSynthSupportedFormats() {
        return new AudioFormat[]{SpeakingThread.createAudioFormat()};
    }

    public void setVoice(String name) {
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public void close() {
        this.silence();
    }

    TTSEngine getTtsEngine() {
        return this.tts;
    }

    private static double convRate(int value) {
        return 1.4;
    }

    private static double convPitch(int value) {
        return 1.0;
    }
}

