/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.base;

import java.util.Objects;
import java.util.concurrent.FutureTask;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.AreaLayoutHelper;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.EventResponse;
import org.luwrain.core.InitResult;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BackgroundSoundQuery;
import org.luwrain.i18n.I18n;

public abstract class AppBase<S>
extends TaskCancelling
implements Application {
    private Luwrain luwrain = null;
    private S strings = null;
    final String stringsName;
    final Class<S> stringsClass;
    private final String helpSection;
    private AreaLayoutHelper layout = null;
    private String appName = "";
    private Area[] visibleAreas = new Area[0];
    private FutureTask task = null;
    private boolean tabProcessing = true;

    public AppBase(String stringsName, Class<S> stringsClass, String helpSection) {
        this.stringsName = Objects.requireNonNull(stringsName, "stringsName");
        this.stringsClass = Objects.requireNonNull(stringsClass, "stringsClass");
        this.helpSection = helpSection;
    }

    public AppBase(String stringsName, Class<S> stringsClass) {
        this(stringsName, stringsClass, null);
    }

    public AppBase(Class<S> stringsClass, String helpSection) {
        this(stringsClass.getName(), stringsClass, helpSection);
    }

    public AppBase(Class<S> stringsClass) {
        this(stringsClass.getName(), stringsClass, null);
    }

    protected abstract AreaLayout onAppInit() throws Exception;

    @Override
    public InitResult onLaunchApp(Luwrain luwrain) {
        AreaLayout initialLayout;
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
        this.strings = luwrain.i18n().getStrings(this.stringsClass);
        try {
            initialLayout = this.onAppInit();
            if (initialLayout == null) {
                throw new Exception("The application is unable to initialize");
            }
        }
        catch (Throwable e) {
            return new InitResult(e);
        }
        this.layout = new AreaLayoutHelper(() -> {
            this.setVisibleAreas(this.layout.getLayout().getAreas());
            luwrain.onNewAreaLayout();
        }, initialLayout);
        this.setVisibleAreas(this.layout.getLayout().getAreas());
        return new InitResult();
    }

    public void closeApp() {
        this.luwrain.closeApp();
    }

    @Override
    public void onAppClose() {
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        NullCheck.notEmpty((Object)appName, (String)"appName");
        this.appName = appName;
    }

    @Override
    public AreaLayout getAreaLayout() {
        return this.layout.getLayout();
    }

    public void onCancelledTask() {
    }

    public boolean onEscape() {
        return false;
    }

    public boolean onInputEvent(Area area, InputEvent event, Runnable closing) {
        Objects.requireNonNull(area, "area can't be null");
        Objects.requireNonNull(event, "event can't be null");
        if (!event.isSpecial() || event.isModified()) {
            return false;
        }
        switch (event.getSpecial()) {
            case ESCAPE: {
                if (this.isBusy()) {
                    this.cancelTask();
                    return true;
                }
                if (closing != null) {
                    closing.run();
                    return true;
                }
                return this.onEscape();
            }
            case TAB: {
                if (this.tabProcessing) {
                    Area nextArea = this.layout.getLayout().getNextArea(area);
                    if (nextArea == null) {
                        return false;
                    }
                    this.luwrain.setActiveArea(nextArea);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean onInputEvent(Area area, InputEvent event) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)event, (String)"event");
        return this.onInputEvent(area, event, null);
    }

    public boolean onSystemEvent(Area area, SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case HELP: {
                if (this.helpSection == null || this.helpSection.isEmpty()) {
                    return false;
                }
                return this.luwrain.openHelp(this.helpSection);
            }
            case CLOSE: {
                this.closeApp();
                return true;
            }
        }
        return false;
    }

    public boolean onSystemEvent(Area area, SystemEvent event, LayoutBase.Actions actions) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() == SystemEvent.Type.REGULAR) {
            switch (event.getCode()) {
                case ACTION: {
                    if (!actions.onActionEvent(event)) break;
                    return true;
                }
            }
        }
        return this.onSystemEvent(area, event);
    }

    public boolean onAreaQuery(Area area, AreaQuery query) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 7: {
                if (this.isBusy()) {
                    ((BackgroundSoundQuery)query).answer(new BackgroundSoundQuery.Answer(BkgSounds.FETCHING));
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    void setVisibleAreas(Area[] visibleAreas) {
        NullCheck.notNullItems((Object[])visibleAreas, (String)"visibleAreas");
        this.visibleAreas = (Area[])visibleAreas.clone();
    }

    private boolean runTask(FutureTask task) {
        Objects.requireNonNull(task, "task can't be null");
        if (this.isBusy()) {
            return false;
        }
        this.task = task;
        this.luwrain.executeBkg(this.task);
        for (Area a : this.visibleAreas) {
            this.luwrain.onAreaNewBackgroundSound(a);
        }
        return true;
    }

    public boolean runTask(TaskCancelling.TaskId taskId, TaskRunnable runnable) {
        Objects.requireNonNull(taskId, "taskId can't be null");
        Objects.requireNonNull(runnable, "runnable can't be null");
        return this.runTask(new FutureTask<Object>(() -> {
            try {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    this.finishedTask(taskId, () -> this.onException(e));
                }
            }
            finally {
                this.finishedTask(taskId, () -> {});
            }
        }, null));
    }

    public synchronized void finishedTask(TaskCancelling.TaskId taskId, Runnable runnable) {
        Objects.requireNonNull(taskId, "taskId can't be null");
        Objects.requireNonNull(runnable, "runnable can't be null");
        if (!this.isBusy() || !taskId.finish()) {
            return;
        }
        this.luwrain.runUiSafely(() -> {
            if (!this.isRunningTaskId(taskId)) {
                return;
            }
            this.resetTask();
            runnable.run();
        });
    }

    @Override
    public void cancelTask() {
        if (!this.isBusy()) {
            return;
        }
        super.cancelTask();
        this.task.cancel(true);
        this.luwrain.playSound(Sounds.CLICK);
        this.resetTask();
        this.onCancelledTask();
    }

    void resetTask() {
        if (this.task == null) {
            return;
        }
        this.task = null;
        for (Area a : this.visibleAreas) {
            this.luwrain.onAreaNewBackgroundSound(a);
        }
    }

    public boolean isBusy() {
        return this.task != null && !this.task.isDone();
    }

    public void onException(Throwable e) {
        this.luwrain.crash(e);
    }

    protected AreaLayoutHelper getLayout() {
        return this.layout;
    }

    public void setAreaLayout(LayoutBase layout) {
        Objects.requireNonNull(layout, "layout can't be null");
        this.getLayout().setBasicLayout(layout.getAreaLayout());
    }

    public Luwrain getLuwrain() {
        return this.luwrain;
    }

    public S getStrings() {
        return this.strings;
    }

    public void crash(Throwable t) {
        NullCheck.notNull((Object)t, (String)"t");
        this.luwrain.crash(t);
    }

    public I18n getI18n() {
        return this.luwrain.i18n();
    }

    public void setEventResponse(EventResponse resp) {
        NullCheck.notNull((Object)resp, (String)"resp");
        this.luwrain.setEventResponse(resp);
    }

    public void message(String text, Luwrain.MessageType type) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)type), (String)"type");
        this.luwrain.message(text, type);
    }

    public void message(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        this.luwrain.message(text);
    }

    protected boolean getTabProcessing() {
        return this.tabProcessing;
    }

    protected void setTabProcessing(boolean tabProcessing) {
        this.tabProcessing = tabProcessing;
    }

    public static interface TaskRunnable {
        public void run() throws Exception;
    }
}

