/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.TreeArea;
import org.luwrain.controls.WrappingControlContext;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.HookContainer;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.script.Hooks;

public class LayoutBase {
    private static final Logger log = LogManager.getLogger();
    protected final AppBase app;
    protected LayoutControlContext controlContext = null;
    private final Map<Area, Area> areaWrappers = new HashMap<Area, Area>();
    private final Map<Area, PropertiesHandler> propHandlers = new HashMap<Area, PropertiesHandler>();
    private AreaLayout areaLayout = null;
    private ActionHandler closeHandler = null;
    private ActionHandler okHandler = null;

    protected LayoutBase(AppBase app) {
        this.app = app;
    }

    protected LayoutBase() {
        this(null);
    }

    public Actions actions(ActionInfo ... a) {
        return new Actions(a);
    }

    public Actions actions(ActionInfo[] a1, ActionInfo ... a2) {
        ArrayList<ActionInfo> res = new ArrayList<ActionInfo>();
        res.addAll(Arrays.asList(a2));
        res.addAll(Arrays.asList(a1));
        return new Actions(res.toArray(new ActionInfo[res.size()]));
    }

    public ActionInfo action(String name, String title, InputEvent inputEvent, ActionHandler handler) {
        return new ActionInfo(name, title, inputEvent, handler);
    }

    public ActionInfo action(String name, String title, ActionHandler handler) {
        return new ActionInfo(name, title, handler);
    }

    public ActionInfo action(String name, String title, InputEvent inputEvent, ActionHandler handler, ActionInfoCondition cond) {
        return new ActionInfo(name, title, inputEvent, handler, cond);
    }

    public ActionInfo action(String name, String title, ActionHandler handler, ActionInfoCondition cond) {
        return new ActionInfo(name, title, handler, cond);
    }

    public void setCloseHandler(ActionHandler closeHandler) {
        this.closeHandler = Objects.requireNonNull(closeHandler, "closeHandler can't be null");
    }

    public void setOkHandler(ActionHandler okHandler) {
        this.okHandler = Objects.requireNonNull(okHandler, "okHandler can't be null");
    }

    public Area getWrappingArea(Area area) {
        Objects.requireNonNull(area, "area can't be null");
        return this.getWrappingArea(area, null);
    }

    public Area getWrappingArea(final Area area, final Actions actions) {
        Objects.requireNonNull(area, "area can't be null");
        if (this.app == null) {
            throw new IllegalStateException("No app instance, provide it using the corresponding constructor");
        }
        Area res = new Area(){

            @Override
            public int getLineCount() {
                try {
                    return area.getLineCount();
                }
                catch (Throwable e) {
                    LayoutBase.this.getLuwrain().crash(e);
                    return 1;
                }
            }

            @Override
            public String getLine(int index) {
                try {
                    return area.getLine(index);
                }
                catch (Throwable e) {
                    LayoutBase.this.getLuwrain().crash(e);
                    return e.getClass().getName() + ": " + e.getMessage();
                }
            }

            @Override
            public int getHotPointX() {
                try {
                    return area.getHotPointX();
                }
                catch (Throwable e) {
                    LayoutBase.this.getLuwrain().crash(e);
                    return 0;
                }
            }

            @Override
            public int getHotPointY() {
                try {
                    return area.getHotPointY();
                }
                catch (Throwable e) {
                    LayoutBase.this.getLuwrain().crash(e);
                    return 0;
                }
            }

            @Override
            public String getAreaName() {
                try {
                    return area.getAreaName();
                }
                catch (Throwable e) {
                    LayoutBase.this.getLuwrain().crash(e);
                    return e.getClass().getName() + ": " + e.getMessage();
                }
            }

            @Override
            public boolean onInputEvent(InputEvent event) {
                if (LayoutBase.this.closeHandler != null ? LayoutBase.this.app.onInputEvent(this, event, () -> LayoutBase.this.closeHandler.onAction()) : LayoutBase.this.app.onInputEvent(this, event)) {
                    return true;
                }
                try {
                    return area.onInputEvent(event);
                }
                catch (Throwable e) {
                    LayoutBase.this.getLuwrain().crash(e);
                    return true;
                }
            }

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                if (actions != null ? LayoutBase.this.app.onSystemEvent(this, event, actions) : LayoutBase.this.app.onSystemEvent(this, event)) {
                    return true;
                }
                try {
                    if (event.getType() == SystemEvent.Type.REGULAR && event.getCode() == SystemEvent.Code.OK && LayoutBase.this.okHandler != null) {
                        return LayoutBase.this.okHandler.onAction();
                    }
                    if (LayoutBase.this.app != null && event.getType() == SystemEvent.Type.REGULAR && event.getCode() == SystemEvent.Code.PROPERTIES && LayoutBase.this.propHandlers.containsKey(area) && LayoutBase.this.propHandlers.get(area) != null) {
                        LayoutBase propLayout = LayoutBase.this.propHandlers.get(area).onProperties(area);
                        if (propLayout == null) {
                            return false;
                        }
                        LayoutBase.this.app.setAreaLayout(propLayout);
                        LayoutBase.this.app.getLuwrain().announceActiveArea();
                        return true;
                    }
                    return area.onSystemEvent(event);
                }
                catch (Throwable e) {
                    LayoutBase.this.getLuwrain().crash(e);
                    return true;
                }
            }

            @Override
            public boolean onAreaQuery(AreaQuery query) {
                if (LayoutBase.this.app.onAreaQuery(this, query)) {
                    return true;
                }
                try {
                    return area.onAreaQuery(query);
                }
                catch (Throwable e) {
                    LayoutBase.this.getLuwrain().crash(e);
                    return false;
                }
            }

            @Override
            public Action[] getAreaActions() {
                try {
                    return actions != null ? actions.getAreaActions() : area.getAreaActions();
                }
                catch (Throwable e) {
                    LayoutBase.this.getLuwrain().crash(e);
                    return new Action[0];
                }
            }
        };
        this.areaWrappers.put(area, res);
        return res;
    }

    public void clearAreaWrappers() {
        this.areaWrappers.clear();
    }

    public void setAreaLayout(Area area, Actions actions) {
        Objects.requireNonNull(area, "area can't be null");
        this.areaLayout = new AreaLayout(this.getWrappingArea(area, actions));
    }

    public void setAreaLayout(AreaLayout.Type type, Area area1, Actions actions1, Area area2, Actions actions2) {
        Objects.requireNonNull(area1, "area1 can't be null");
        Objects.requireNonNull(area2, "area2 can't be null");
        this.areaLayout = new AreaLayout(type, this.getWrappingArea(area1, actions1), this.getWrappingArea(area2, actions2));
    }

    public void setAreaLayout(AreaLayout.Type type, Area area1, Actions actions1, Area area2, Actions actions2, Area area3, Actions actions3) {
        Objects.requireNonNull(area1, "area1 can't be null");
        Objects.requireNonNull(area2, "area2 can't be null");
        Objects.requireNonNull(area3, "area3 can't be null");
        this.areaLayout = new AreaLayout(type, this.getWrappingArea(area1, actions1), this.getWrappingArea(area2, actions2), this.getWrappingArea(area3, actions3));
    }

    public AreaLayout getAreaLayout() {
        if (this.areaLayout == null) {
            throw new IllegalStateException("No area layout, use setAreaLayout() to set it");
        }
        return this.areaLayout;
    }

    public ControlContext getControlContext() {
        if (this.app == null) {
            throw new IllegalStateException("No app instance, provide it with the corresponding constructor");
        }
        if (this.controlContext == null) {
            this.controlContext = new LayoutControlContext(new DefaultControlContext(this.app.getLuwrain()));
        }
        return this.controlContext;
    }

    public Luwrain getLuwrain() {
        if (this.app == null) {
            throw new IllegalStateException("No app instance, provide it with the corresponding constructor");
        }
        return this.app.getLuwrain();
    }

    public void setActiveArea(Area area) {
        Objects.requireNonNull(area, "area can't be null");
        if (this.app == null) {
            throw new IllegalStateException("No app instance, provide it with the corresponding constructor");
        }
        Area a = this.areaWrappers.get(area);
        this.app.getLuwrain().setActiveArea(a != null ? a : area);
    }

    public int getAreaVisibleWidth(Area area) {
        Objects.requireNonNull(area, "area can't be null");
        if (this.app == null) {
            throw new IllegalStateException("No app instance, provide it with the corresponding constructor");
        }
        Area a = this.areaWrappers.get(area);
        return this.app.getLuwrain().getAreaVisibleWidth(a != null ? a : area);
    }

    public int getAreaVisibleHeight(Area area) {
        Objects.requireNonNull(area, "area can't be null");
        if (this.app == null) {
            throw new IllegalStateException("No app instance, provide it with the corresponding constructor");
        }
        Area a = this.areaWrappers.get(area);
        return this.app.getLuwrain().getAreaVisibleHeight(a != null ? a : area);
    }

    public void setPropertiesHandler(Area area, PropertiesHandler handler) {
        Objects.requireNonNull(area, "area can't be null");
        Objects.requireNonNull(handler, "handler can't be null");
        this.propHandlers.put(area, handler);
    }

    public ActionHandler getReturnAction() {
        if (this.app == null) {
            throw new IllegalStateException("No app instance, provide it using the corresponding constructor");
        }
        return () -> {
            this.app.setAreaLayout(this);
            this.app.getLuwrain().announceActiveArea();
            return true;
        };
    }

    public <E> ListArea.Params<E> listParams(ListParams<E> l) {
        Objects.requireNonNull(l, "l can't be null");
        ListArea.Params params = new ListArea.Params();
        params.context = this.getControlContext();
        params.appearance = new ListUtils.DefaultAppearance(this.getControlContext());
        l.setListParams(params);
        return params;
    }

    public EditArea.Params editParams(EditParams l) {
        Objects.requireNonNull(l, "l can't be null");
        EditArea.Params params = new EditArea.Params(this.getControlContext());
        l.setEditParams(params);
        if (params.inputEventListeners != null) {
            log.debug(String.valueOf(params.inputEventListeners.size()) + " edit input listeners");
        }
        return params;
    }

    public <E> ConsoleArea.Params<E> consoleParams(ConsoleParams<E> l) {
        NullCheck.notNull(l, (String)"l");
        ConsoleArea.Params params = new ConsoleArea.Params();
        params.context = this.getControlContext();
        l.setConsoleParams(params);
        return params;
    }

    public <E> TreeArea.Params treeParams(TreeParams<E> l) {
        Objects.requireNonNull(l, "l can't be null");
        TreeArea.Params params = new TreeArea.Params();
        l.setTreeParams(params);
        params.context = this.getControlContext();
        return params;
    }

    public Hooks getHooks() {
        return new Hooks();
    }

    protected final class LayoutControlContext
    extends WrappingControlContext {
        public LayoutControlContext(ControlContext context) {
            super(context);
        }

        @Override
        public void onAreaNewContent(Area area) {
            super.onAreaNewContent(this.getArea(area));
        }

        @Override
        public void onAreaNewName(Area area) {
            super.onAreaNewName(this.getArea(area));
        }

        @Override
        public void onAreaNewHotPoint(Area area) {
            super.onAreaNewHotPoint(this.getArea(area));
        }

        @Override
        public int getAreaVisibleHeight(Area area) {
            return super.getAreaVisibleHeight(this.getArea(area));
        }

        @Override
        public int getAreaVisibleWidth(Area area) {
            return this.getAreaVisibleWidth(this.getArea(area));
        }

        @Override
        public void onAreaNewBackgroundSound(Area area) {
            super.onAreaNewBackgroundSound(this.getArea(area));
        }

        @Override
        public boolean runHooks(String hookName, HookContainer.HookRunner runner) {
            return LayoutBase.this.getLuwrain().runHooks(hookName, runner);
        }

        private Area getArea(Area area) {
            Objects.requireNonNull(area, "area can't be null");
            Area res = LayoutBase.this.areaWrappers.get(area);
            return res != null ? res : area;
        }
    }

    public static interface ActionHandler {
        public boolean onAction();
    }

    public static final class Actions {
        private final ActionInfo[] actions;

        public Actions(ActionInfo[] actions) {
            NullCheck.notNullItems((Object[])actions, (String)"actions");
            this.actions = (ActionInfo[])actions.clone();
        }

        public Actions() {
            this(new ActionInfo[0]);
        }

        public Action[] getAreaActions() {
            ArrayList<Action> res = new ArrayList<Action>();
            for (ActionInfo a : this.actions) {
                if (a.cond != null && !a.cond.isActionInfoEnabled()) continue;
                if (a.inputEvent != null) {
                    res.add(new Action(a.name, a.title, a.inputEvent));
                    continue;
                }
                res.add(new Action(a.name, a.title));
            }
            return res.toArray(new Action[res.size()]);
        }

        public boolean handle(String actionName) {
            NullCheck.notEmpty((Object)actionName, (String)"actionName");
            for (ActionInfo a : this.actions) {
                if (!a.name.equals(actionName)) continue;
                return a.handler.onAction();
            }
            return false;
        }

        boolean onActionEvent(SystemEvent event) {
            Objects.requireNonNull(event, "event can't be null");
            for (ActionInfo a : this.actions) {
                if (!ActionEvent.isAction(event, a.name)) continue;
                return a.handler.onAction();
            }
            return false;
        }
    }

    public final class ActionInfo {
        final String name;
        final String title;
        final InputEvent inputEvent;
        final ActionHandler handler;
        final ActionInfoCondition cond;

        public ActionInfo(String name, String title, InputEvent inputEvent, ActionHandler handler, ActionInfoCondition cond) {
            NullCheck.notEmpty((Object)name, (String)"name");
            NullCheck.notEmpty((Object)title, (String)"title");
            this.name = name;
            this.title = title;
            this.inputEvent = inputEvent;
            this.handler = Objects.requireNonNull(handler, "handler can't be null");
            this.cond = cond;
        }

        public ActionInfo(String name, String title, InputEvent inputEvent, ActionHandler handler) {
            this(name, title, inputEvent, handler, null);
        }

        public ActionInfo(String name, String title, ActionHandler handler, ActionInfoCondition cond) {
            this(name, title, null, handler, cond);
        }

        public ActionInfo(String name, String title, ActionHandler handler) {
            this(name, title, null, handler, null);
        }
    }

    public static interface ActionInfoCondition {
        public boolean isActionInfoEnabled();
    }

    public static interface ListParams<E> {
        public void setListParams(ListArea.Params<E> var1);
    }

    public static interface EditParams {
        public void setEditParams(EditArea.Params var1);
    }

    public static interface ConsoleParams<E> {
        public void setConsoleParams(ConsoleArea.Params<E> var1);
    }

    public static interface TreeParams<E> {
        public void setTreeParams(TreeArea.Params var1);
    }

    public static interface PropertiesHandler {
        public LayoutBase onProperties(Area var1);
    }
}

