/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.base;

import org.luwrain.core.NullCheck;

public class TaskCancelling {
    private volatile long id = 0L;
    private volatile boolean cancelled = false;

    public synchronized TaskId newTaskId() {
        ++this.id;
        this.cancelled = false;
        return new TaskId(this.id);
    }

    public synchronized void cancelTask() {
        this.cancelled = true;
    }

    public synchronized boolean isRunningTaskId(TaskId taskId) {
        NullCheck.notNull((Object)taskId, (String)"taskId");
        return this.id == taskId.getId() && !this.cancelled;
    }

    public static final class TaskId {
        private final long id;
        private boolean finished = false;

        public TaskId(long id) {
            if (id < 0L) {
                throw new IllegalArgumentException("id (" + String.valueOf(id) + ") may not be negative");
            }
            this.id = id;
        }

        protected long getId() {
            return this.id;
        }

        protected boolean finish() {
            if (this.finished) {
                return false;
            }
            this.finished = true;
            return true;
        }
    }
}

