/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.controls.CachedTreeModelSource;
import org.luwrain.controls.TreeArea;
import org.luwrain.core.NullCheck;

public class CachedTreeModel
implements TreeArea.Model {
    private final CachedTreeModelSource source;
    private final List<CacheItem> cache = new ArrayList<CacheItem>();

    public CachedTreeModel(CachedTreeModelSource source) {
        NullCheck.notNull((Object)source, (String)"source");
        this.source = source;
    }

    @Override
    public Object getRoot() {
        return this.source.getRoot();
    }

    @Override
    public void beginChildEnumeration(Object node) {
        Object[] objs;
        NullCheck.notNull((Object)node, (String)"node");
        CacheItem newItem = null;
        for (CacheItem c : this.cache) {
            if (!c.parent.equals(node)) continue;
            newItem = c;
        }
        if (newItem == null) {
            newItem = new CacheItem(node);
            this.cache.add(newItem);
        }
        if ((objs = this.source.getChildObjs(node)) == null || objs.length < 1) {
            newItem.objs = new Object[0];
            return;
        }
        newItem.objs = objs;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == null) {
            return 0;
        }
        for (CacheItem c : this.cache) {
            if (!c.parent.equals(parent)) continue;
            return c.objs.length;
        }
        return 0;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == null) {
            return null;
        }
        for (CacheItem c : this.cache) {
            if (!c.parent.equals(parent)) continue;
            return c.objs[index];
        }
        return null;
    }

    @Override
    public void endChildEnumeration(Object node) {
    }

    protected static class CacheItem {
        private final Object parent;
        private Object[] objs = new Object[0];

        CacheItem(Object parent) {
            NullCheck.notNull((Object)parent, (String)"parent");
            this.parent = parent;
        }
    }
}

