/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.luwrain.core.LineMarks;
import org.luwrain.core.NullCheck;
import org.luwrain.util.RangeUtils;

public class DefaultLineMarks
implements LineMarks {
    final LineMarks.Mark[] marks;

    DefaultLineMarks(LineMarks.Mark[] marks) {
        NullCheck.notNullItems((Object[])marks, (String)"marks");
        this.marks = marks;
    }

    @Override
    public LineMarks.Mark[] getMarks() {
        return (LineMarks.Mark[])this.marks.clone();
    }

    @Override
    public LineMarks.Mark[] findAtPos(int pos) {
        ArrayList<LineMarks.Mark> res = new ArrayList<LineMarks.Mark>();
        for (LineMarks.Mark m : this.marks) {
            if (!RangeUtils.between(pos, m.getPosFrom(), m.getPosTo())) continue;
            res.add(m);
        }
        return res.toArray(new LineMarks.Mark[res.size()]);
    }

    @Override
    public DefaultLineMarks filter(Predicate<LineMarks.Mark> cond) {
        NullCheck.notNull(cond, (String)"cond");
        ArrayList<LineMarks.Mark> res = new ArrayList<LineMarks.Mark>();
        for (LineMarks.Mark m : this.marks) {
            if (!cond.test(m)) continue;
            res.add(m);
        }
        return new DefaultLineMarks(res.toArray(new LineMarks.Mark[res.size()]));
    }

    public static final class MarkImpl
    implements LineMarks.Mark {
        final LineMarks.Mark.Type type;
        final int posFrom;
        final int posTo;
        final LineMarks.MarkObject obj;

        public MarkImpl(LineMarks.Mark.Type type, int posFrom, int posTo, LineMarks.MarkObject obj) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            this.type = type;
            this.posFrom = posFrom;
            this.posTo = posTo;
            this.obj = obj;
        }

        @Override
        public LineMarks.Mark.Type getType() {
            return this.type;
        }

        @Override
        public int getPosFrom() {
            return this.posFrom;
        }

        @Override
        public int getPosTo() {
            return this.posTo;
        }

        @Override
        public LineMarks.MarkObject getMarkObject() {
            return this.obj;
        }
    }

    public static final class Builder {
        private final List<LineMarks.Mark> res = new ArrayList<LineMarks.Mark>();

        public Builder(LineMarks marks) {
            LineMarks.Mark[] newMarks;
            if (marks != null && (newMarks = marks.getMarks()) != null) {
                this.res.addAll(Arrays.asList(newMarks));
            }
        }

        public Builder add(LineMarks.Mark mark) {
            NullCheck.notNull((Object)mark, (String)"mark");
            this.res.add(mark);
            return this;
        }

        public Builder addAll(List<LineMarks.Mark> marks) {
            NullCheck.notNull(marks, (String)"marks");
            this.res.addAll(marks);
            return this;
        }

        public Builder addAll(LineMarks.Mark[] marks) {
            NullCheck.notNullItems((Object[])marks, (String)"marks");
            this.res.addAll(Arrays.asList(marks));
            return this;
        }

        public DefaultLineMarks build() {
            return new DefaultLineMarks(this.res.toArray(new LineMarks.Mark[this.res.size()]));
        }
    }
}

