/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

class TableCell {
    public int pos = 0;
    public int shift = 0;
    public int width = 0;
    public String line;

    public TableCell(int pos, int shift, int width, String line) {
        this.pos = pos;
        this.shift = shift;
        this.width = width;
        this.line = line;
        if (line == null) {
            throw new NullPointerException("line may not be null");
        }
    }

    public boolean moveNext() {
        this.normalize();
        if (this.pos + this.shift >= this.line.length()) {
            return false;
        }
        if (this.pos + this.shift == this.line.length() - 1) {
            ++this.pos;
            return true;
        }
        if (this.pos == this.width - 1) {
            ++this.shift;
        } else {
            ++this.pos;
        }
        return true;
    }

    public boolean movePrev() {
        this.normalize();
        if (this.pos + this.shift <= 0) {
            return false;
        }
        if (this.pos > 0) {
            --this.pos;
        } else {
            --this.shift;
        }
        return true;
    }

    private void normalize() {
        if (this.line.length() <= this.width) {
            this.pos += this.shift;
            this.shift = 0;
            if (this.pos < 0) {
                this.pos = 0;
            }
            if (this.pos > this.line.length()) {
                this.pos = this.line.length();
            }
            return;
        }
        if (this.line.length() < this.width + this.shift) {
            int absPos = this.pos + this.shift;
            this.shift = this.line.length() - this.width;
            this.pos = absPos - this.shift;
        }
        if (this.pos + this.shift > this.line.length()) {
            this.pos = this.line.length() - this.shift;
        }
        if (this.pos + this.shift == this.line.length()) {
            this.pos = this.width;
            this.shift = this.line.length() - this.width;
            return;
        }
        if (this.pos + this.shift < 0) {
            this.pos = 0 - this.shift;
        }
        if (this.pos < 0) {
            this.shift = this.pos;
            this.pos = 0;
        }
        if (this.pos > this.width) {
            this.shift = this.pos - this.width + 1;
            this.pos = this.width - 1;
        }
    }
}

