/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import com.google.gson.Gson;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.function.Supplier;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.util.TextUtils;

public final class Clipboard
implements ClipboardOwner,
Supplier<Object> {
    private static final String LOG_COMPONENT = "core";
    private final Gson gson = new Gson();
    private Obj<?>[] objs = null;
    private String systemClipboard = null;

    public <E> boolean set(E[] o) {
        int i;
        if (o == null) {
            return false;
        }
        for (i = 0; i < o.length; ++i) {
            if (o[i] != null && !o[i].getClass().isArray()) continue;
            return false;
        }
        this.objs = new Obj[o.length];
        for (i = 0; i < o.length; ++i) {
            this.objs[i] = this.saveObj(o[i], o[i].toString());
        }
        this.setSystemClipboard();
        return true;
    }

    public boolean set(Object[] o, String[] s) {
        int i;
        if (o == null || s == null) {
            return false;
        }
        if (o.length != s.length) {
            return false;
        }
        for (i = 0; i < o.length; ++i) {
            if (o[i] == null || s[i] == null) {
                return false;
            }
            if (!o[i].getClass().isArray()) continue;
            return false;
        }
        this.objs = new Obj[o.length];
        for (i = 0; i < o.length; ++i) {
            this.objs[i] = this.saveObj(o[i], s[i]);
        }
        this.setSystemClipboard();
        return true;
    }

    public boolean set(Object o) {
        if (o == null || o.getClass().isArray()) {
            return false;
        }
        return this.set(new Object[]{o});
    }

    private void setSystemClipboard() {
        if (this.objs == null || this.objs.length == 0) {
            return;
        }
        StringBuilder b = new StringBuilder();
        String lineSep = System.lineSeparator();
        for (Obj<?> o : this.objs) {
            b.append(o.str).append(lineSep);
        }
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(new String(b)), this);
        }
        catch (Throwable e) {
            Log.error(LOG_COMPONENT, "unable to set the system clipboard: " + e.getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public Object[] get() {
        if (this.objs == null) {
            return this.getSystemClipboard();
        }
        Object[] res = new Object[this.objs.length];
        for (int i = 0; i < this.objs.length; ++i) {
            res[i] = this.restore(this.objs[i]);
        }
        return res;
    }

    public String[] getStrings() {
        if (this.objs == null) {
            return this.getSystemClipboard();
        }
        String[] res = new String[this.objs.length];
        for (int i = 0; i < this.objs.length; ++i) {
            res[i] = this.objs[i].str;
        }
        return res;
    }

    public String getString(String lineSep) {
        String[] str = this.getStrings();
        if (str == null || str.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(str[0]);
        for (int i = 1; i < str.length; ++i) {
            b.append(str[i]).append(lineSep);
        }
        return new String(b);
    }

    private String[] getSystemClipboard() {
        String s;
        try {
            s = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            Log.debug(LOG_COMPONENT, "system clipboard content is '" + s + "'");
            if (s == null) {
                return new String[0];
            }
        }
        catch (Throwable e) {
            Log.error(LOG_COMPONENT, "unable to set the system clipboard: " + e.getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        return TextUtils.splitLines(s);
    }

    public boolean isEmpty() {
        if (this.objs == null || this.objs.length == 0) {
            String[] s = this.getSystemClipboard();
            return s == null || s.length == 0;
        }
        return false;
    }

    public void clear() {
        this.objs = null;
    }

    private <E> Obj saveObj(E o, String s) {
        NullCheck.notNull(o, (String)"o");
        NullCheck.notNull((Object)s, (String)"s");
        if (o instanceof String) {
            return new Obj<String>(String.class, null, o.toString(), (String)o);
        }
        if (o instanceof URL) {
            return new Obj<URL>(URL.class, null, s, (URL)o);
        }
        if (o instanceof File) {
            return new Obj<File>(File.class, null, s, (File)o);
        }
        if (o instanceof URI) {
            return new Obj<URI>(URI.class, null, s, (URI)o);
        }
        StringWriter w = new StringWriter();
        this.gson.toJson(o, (Appendable)w);
        w.flush();
        return new Obj<Object>(o.getClass(), w.toString(), s, null);
    }

    private <E> E restore(Obj<E> obj) {
        NullCheck.notNull(obj, (String)"obj");
        if (obj.obj != null) {
            return obj.obj;
        }
        NullCheck.notNull((Object)obj.content, (String)"obj.content");
        return (E)this.gson.fromJson(obj.content, obj.cl);
    }

    @Override
    public void lostOwnership(java.awt.datatransfer.Clipboard clipboard, Transferable contents) {
        Log.debug(LOG_COMPONENT, "the clipboard lost ownership");
        this.objs = null;
    }

    private static final class Obj<E> {
        final Class<E> cl;
        final String content;
        final String str;
        final E obj;

        Obj(Class<E> cl, String content, String str, E obj) {
            NullCheck.notNull(cl, (String)"cl");
            NullCheck.notNull((Object)str, (String)"str");
            this.cl = cl;
            this.content = content;
            this.str = str;
            this.obj = obj;
        }
    }
}

