/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.luwrain.core.Action;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Areas;
import org.luwrain.core.Base;
import org.luwrain.core.Config;
import org.luwrain.core.Event;
import org.luwrain.core.GlobalKeys;
import org.luwrain.core.Keyboard;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.listening.Listening;

abstract class EventDispatching
extends Areas {
    protected final GlobalKeys globalKeys = new GlobalKeys(this.args, this.configs);
    protected Listening listening = null;
    private AtomicBoolean idleEventCancelling = null;

    protected EventDispatching(Config conf) {
        super(conf);
    }

    protected abstract void onBeforeEventProcessing();

    protected abstract void onAltX();

    @Override
    protected void onEvent(Event event) {
        try {
            if (event instanceof RunnableEvent) {
                this.unsafeAreaOperation(() -> ((RunnableEvent)event).runnable.run());
                return;
            }
            if (event instanceof CallableEvent) {
                CallableEvent callableEvent = (CallableEvent)event;
                this.unsafeAreaOperation(() -> {
                    try {
                        callableEvent.setResult(callableEvent.callable.call());
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
                return;
            }
            if (event instanceof InputEvent) {
                this.onInputEvent(Keyboard.translate((InputEvent)event));
                return;
            }
            if (event instanceof SystemEvent) {
                SystemEvent systemEvent = (SystemEvent)event;
                if (systemEvent.getType() == null) {
                    return;
                }
                switch (systemEvent.getType()) {
                    case REGULAR: {
                        this.onSystemEvent(systemEvent);
                        return;
                    }
                    case BROADCAST: {
                        this.onBroadcastSystemEvent(systemEvent);
                        return;
                    }
                }
                return;
            }
            return;
        }
        catch (Throwable e) {
            Log.error("core", "an exception of class " + e.getClass().getName() + " has been thrown while processing of event of class " + event.getClass().getName() + "::" + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void announce(Base.StopCondition stopCondition) {
        Objects.requireNonNull(stopCondition, "stopCondition can't be null");
        if (this.announcement != null && stopCondition.continueEventLoop() && this.listening == null) {
            switch (this.announcement) {
                case APP: {
                    this.announceActiveApp();
                    break;
                }
                case AREA: {
                    this.announceActiveArea();
                }
            }
        }
        this.announcement = null;
    }

    private void onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        this.onBeforeEventProcessing();
        if (this.systemHotKey(event)) {
            return;
        }
        Area activeArea = this.tiles.getActiveArea();
        if (activeArea == null) {
            this.noAppsMessage();
            return;
        }
        this.unsafeAreaOperation(() -> {
            Action[] actions = activeArea.getAreaActions();
            if (actions != null) {
                for (Action a : actions) {
                    InputEvent actionEvent = a.inputEvent;
                    if (actionEvent == null || !actionEvent.equals(event)) continue;
                    if (!activeArea.onSystemEvent(new ActionEvent(a))) break;
                    return;
                }
            }
            if (!activeArea.onInputEvent(event)) {
                this.soundManager.playIcon(Sounds.INACCESSIBLE);
            }
            this.installIdleEvent();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installIdleEvent() {
        AtomicBoolean cancelling = new AtomicBoolean(false);
        EventDispatching eventDispatching = this;
        synchronized (eventDispatching) {
            if (this.idleEventCancelling != null) {
                this.idleEventCancelling.set(true);
            }
            this.idleEventCancelling = cancelling;
        }
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
            if (cancelling.get()) {
                return;
            }
            this.enqueueEvent(new SystemEvent(SystemEvent.Code.IDLE));
        }).start();
    }

    private boolean systemHotKey(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        String commandName = this.globalKeys.getCommandName(event);
        if (commandName != null) {
            if (!this.commands.run(commandName)) {
                this.message(this.i18n.getStaticStr("NoCommand"), Luwrain.MessageType.ERROR);
            }
            return true;
        }
        if (event.isSpecial()) {
            InputEvent.Special code = event.getSpecial();
            if (code == InputEvent.Special.CONTROL) {
                this.speech.silence();
                this.soundManager.cancelIcon();
                this.soundManager.stopStartingMode();
                return true;
            }
            if (code == InputEvent.Special.SHIFT || code == InputEvent.Special.CONTROL || code == InputEvent.Special.LEFT_ALT || code == InputEvent.Special.RIGHT_ALT) {
                return true;
            }
        }
        if (!event.isSpecial() && InputEvent.getKeyboardLayout().onSameButton(event.getChar(), 'x') && event.withAltOnly()) {
            this.onAltX();
            return true;
        }
        return false;
    }

    private void onSystemEvent(SystemEvent event) {
        Area activeArea = this.tiles.getActiveArea();
        if (activeArea == null) {
            this.noAppsMessage();
            return;
        }
        AtomicBoolean processed = new AtomicBoolean();
        this.unsafeAreaOperation(() -> processed.set(activeArea.onSystemEvent(event)));
        if (processed.get()) {
            return;
        }
        if (event.getCode() != SystemEvent.Code.IDLE) {
            this.soundManager.playIcon(Sounds.INACCESSIBLE);
        }
    }

    private void onBroadcastSystemEvent(SystemEvent event) {
        this.apps.sendBroadcastEvent(event);
    }

    private void announceActiveApp() {
        Application app = this.apps.getActiveApp();
        if (app == null) {
            this.noAppsMessage();
            return;
        }
        AtomicReference<String> name = new AtomicReference<String>();
        AtomicReference layout = new AtomicReference();
        this.unsafeAreaOperation(() -> {
            name.set(app.getAppName());
            layout.set(app.getAreaLayout());
        });
        if (name.get() == null || ((String)name.get()).isEmpty()) {
            name.set(app.getClass().getName());
        }
        Sounds sound = Sounds.AREA_LAYOUT;
        if (layout.get() != null) {
            switch (((AreaLayout)layout.get()).layoutType) {
                case LEFT_RIGHT: 
                case TOP_BOTTOM: {
                    sound = Sounds.AREA_LAYOUT_DOUBLE;
                    break;
                }
                case LEFT_RIGHT_BOTTOM: 
                case LEFT_TOP_BOTTOM: {
                    sound = Sounds.AREA_LAYOUT_TRIPLE;
                }
            }
        }
        this.soundManager.playIcon(sound);
        this.speech.speak((String)name.get(), 0, 0);
    }

    void announceActiveArea() {
        String value;
        Area activeArea = this.tiles.getActiveArea();
        if (activeArea == null) {
            this.noAppsMessage();
            return;
        }
        AtomicReference res = new AtomicReference();
        this.unsafeAreaOperation(() -> res.set(activeArea.onSystemEvent(new SystemEvent(SystemEvent.Code.INTRODUCE))));
        if (res.get() != null && ((Boolean)res.get()).booleanValue()) {
            return;
        }
        this.speech.silence();
        this.soundManager.playIcon(activeArea instanceof Popup ? Sounds.POPUP : Sounds.INTRO_REGULAR);
        this.unsafeAreaOperation(() -> {
            String value = activeArea.getAreaName();
            if (value != null) {
                res.set(value);
            }
        });
        String name = res != null ? ((value = res.get().toString()) != null && !value.trim().isEmpty() ? value : activeArea.getClass().getName()) : activeArea.getClass().getName();
        this.speech.speak(name, 0, 0);
    }

    static class RunnableEvent
    extends Event {
        final Runnable runnable;

        RunnableEvent(Runnable runnable) {
            NullCheck.notNull((Object)runnable, (String)"runnable");
            this.runnable = runnable;
        }
    }

    static class CallableEvent
    extends Event {
        final Callable callable;
        private Object result = null;

        CallableEvent(Callable callable) {
            NullCheck.notNull((Object)callable, (String)"callable");
            this.callable = callable;
        }

        void setResult(Object result) {
            this.result = result;
        }

        Object getResult() {
            return this.result;
        }
    }
}

