/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.LinkedList;
import org.luwrain.core.Base;
import org.luwrain.core.Event;
import org.luwrain.core.NullCheck;

final class EventQueue {
    private static final int MAX_LEN_LIMIT = 1024;
    private static final String LOG_COMPONENT = "core";
    private final LinkedList<Event> events = new LinkedList();

    EventQueue() {
    }

    synchronized void putEvent(Event e) {
        NullCheck.notNull((Object)e, (String)"e");
        if (this.events.size() >= 1024) {
            Base.warn("exceeding max number of unprocessed  events in the events queue (1024)");
            return;
        }
        this.events.addLast(e);
        this.notify();
    }

    synchronized Event pickEvent() {
        try {
            while (this.events.isEmpty()) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Event e = this.events.pollFirst();
        return e;
    }
}

