/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.Objects;

public final class InitResult {
    private final Type type;
    private final String message;
    private Throwable exception;

    public InitResult() {
        this.type = Type.OK;
        this.message = null;
        this.exception = null;
    }

    public InitResult(Type type) {
        this.type = Objects.requireNonNull(type, "type can't be null");
        this.message = null;
        this.exception = null;
    }

    public InitResult(Type type, String message) {
        this.type = Objects.requireNonNull(type, "type can't be null");
        this.message = Objects.requireNonNull(message, "message can't be null");
    }

    public InitResult(Throwable e) {
        this.type = Type.EXCEPTION;
        this.message = null;
        this.exception = Objects.requireNonNull(e, "e can't be null");
    }

    public boolean isOk() {
        return this.type == Type.OK;
    }

    public Type getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitResult)) {
            return false;
        }
        InitResult other = (InitResult)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "InitResult(type=" + String.valueOf((Object)this.getType()) + ", message=" + this.getMessage() + ", exception=" + String.valueOf(this.getException()) + ")";
    }

    public static enum Type {
        OK,
        FAILURE,
        EXCEPTION,
        NO_STRINGS_OBJ,
        NETWORK_SERVICE_INACCESSIBLE;

    }
}

