/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.Objects;
import org.luwrain.core.EventConsumer;
import org.luwrain.core.OperatingSystem;

public interface Interaction {
    public boolean init(Params var1, OperatingSystem var2);

    public void close();

    public void startInputEventsAccepting(EventConsumer var1);

    public void stopInputEventsAccepting();

    public boolean setDesirableFontSize(int var1);

    public int getFontSize();

    public int getWidthInCharacters();

    public int getHeightInCharacters();

    public void startDrawSession();

    public void clearRect(int var1, int var2, int var3, int var4);

    public void drawText(int var1, int var2, String var3);

    public void drawText(int var1, int var2, String var3, boolean var4);

    public void endDrawSession();

    public void setHotPoint(int var1, int var2);

    public void drawVerticalLine(int var1, int var2, int var3);

    public void drawHorizontalLine(int var1, int var2, int var3);

    public void showGraphical(GraphicalMode var1);

    public static interface GraphicalMode {
        public Object getGraphicalObj(GraphicalModeControl var1);
    }

    public static interface GraphicalModeControl {
        public void close();
    }

    public static final class Params {
        public int wndLeft = 0;
        public int wndTop = 0;
        public int wndWidth = -1;
        public int wndHeight = -1;
        public int marginLeft = 16;
        public int marginTop = 16;
        public int marginRight = 16;
        public int marginBottom = 16;
        public Color fontColor = new Color(Color.Predefined.GRAY);
        public Color font2Color = new Color(Color.Predefined.WHITE);
        public Color bkgColor = new Color(Color.Predefined.BLACK);
        public Color splitterColor = new Color(Color.Predefined.LIGHT_GRAY);
        public int initialFontSize = 14;
        public String fontName = "Monospaced";
    }

    public static final class Color {
        public Predefined predefined = null;
        public float red = 0.0f;
        public float green = 0.0f;
        public float blue = 0.0f;

        public Color(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.predefined = null;
        }

        public Color(Predefined predefined) {
            this.predefined = Objects.requireNonNull(predefined, "predefined can't be null");
        }

        public static enum Predefined {
            WHITE,
            LIGHT_GRAY,
            GRAY,
            DARK_GRAY,
            BLACK,
            RED,
            PINK,
            ORANGE,
            YELLOW,
            GREEN,
            MAGENTA,
            CYAN,
            BLUE;

        }
    }
}

