/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.Application;
import org.luwrain.core.Base;
import org.luwrain.core.Core;
import org.luwrain.core.Extension;
import org.luwrain.core.Luwrain;
import org.luwrain.core.LuwrainImpl;
import org.luwrain.core.NullCheck;

final class InterfaceManager {
    private final Core core;
    private final List<Entry> entries = new ArrayList<Entry>();
    final Luwrain systemObj;

    InterfaceManager(Base base) {
        NullCheck.notNull((Object)base, (String)"base");
        this.core = (Core)base;
        this.systemObj = new LuwrainImpl(this.core);
    }

    Luwrain requestNew(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        Luwrain existing = this.findFor(app);
        if (existing != null) {
            return existing;
        }
        LuwrainImpl luwrain = new LuwrainImpl(this.core);
        this.entries.add(new Entry(Entry.Type.APP, app, luwrain));
        return luwrain;
    }

    Luwrain requestNew(Extension ext) {
        NullCheck.notNull((Object)ext, (String)"ext");
        Luwrain existing = this.findFor(ext);
        if (existing != null) {
            return existing;
        }
        LuwrainImpl luwrain = new LuwrainImpl(this.core);
        this.entries.add(new Entry(Entry.Type.EXT, ext, luwrain));
        return luwrain;
    }

    private Luwrain findFor(Object obj) {
        NullCheck.notNull((Object)obj, (String)"obj");
        for (Entry e : this.entries) {
            if (e.obj != obj) continue;
            return e.luwrain;
        }
        return null;
    }

    Application findApp(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        for (Entry e : this.entries) {
            if (e.luwrain != luwrain || e.type != Entry.Type.APP || !(e.obj instanceof Application)) continue;
            return (Application)e.obj;
        }
        return null;
    }

    Extension findExt(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        for (Entry e : this.entries) {
            if (e.luwrain != luwrain || e.type != Entry.Type.EXT || !(e.obj instanceof Extension)) continue;
            return (Extension)e.obj;
        }
        return null;
    }

    void release(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get((int)i).luwrain != luwrain) continue;
            this.entries.remove(i);
            return;
        }
    }

    boolean forPopupsWithoutApp(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        return luwrain == this.systemObj || this.findExt(luwrain) != null;
    }

    private static final class Entry {
        final Type type;
        final Object obj;
        final Luwrain luwrain;

        Entry(Type type, Object obj, Luwrain luwrain) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNull((Object)obj, (String)"obj");
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            this.type = type;
            this.obj = obj;
            this.luwrain = luwrain;
        }

        static enum Type {
            APP,
            EXT;

        }
    }
}

