/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import org.luwrain.core.Log;

public class JniLoader {
    private static final String LOG_COMPONENT = "core";
    private static final String AUTOLOAD = "autoload.txt";
    private final String arch = System.getProperty("sun.arch.data.model");
    private final String os = System.getProperty("os.name");
    private final String path = "org/luwrain/jni/" + this.os + "/" + this.arch + "/";

    void autoload(ClassLoader classLoader) {
        if (classLoader == null) {
            Log.error(LOG_COMPONENT, "unable to load JNI: classLoader is null");
            return;
        }
        String[] libs = this.getAutoloadList(classLoader);
        if (libs == null || libs.length == 0) {
            return;
        }
        for (String l : libs) {
            Log.debug(LOG_COMPONENT, "loading library " + l);
            this.load(classLoader, l);
        }
    }

    private String[] getAutoloadList(ClassLoader classLoader) {
        String[] stringArray;
        String name = this.path + AUTOLOAD;
        URL url = classLoader.getResource(name);
        if (url == null) {
            Log.debug(LOG_COMPONENT, "no resource " + name + ", skipping JNI autoloading");
            return null;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
        try {
            ArrayList<String> res = new ArrayList<String>();
            String line = r.readLine();
            while (line != null) {
                res.add(line);
                line = r.readLine();
            }
            stringArray = res.toArray(new String[res.size()]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Log.error(LOG_COMPONENT, "JNI loading failed: unable to read the resource with name " + name + ": " + e.getClass().getName() + ": " + e.getMessage());
                return null;
            }
        }
        r.close();
        return stringArray;
    }

    public boolean load(ClassLoader classLoader, String name) {
        if (classLoader == null || name == null || name.isEmpty()) {
            return false;
        }
        String resName = this.path + name;
        URL url = classLoader.getResource(resName);
        if (url == null) {
            Log.error(LOG_COMPONENT, "unable to load JNI library: no such resource: " + resName);
            return false;
        }
        try {
            File tmpFile = File.createTempFile(".lwr.jni.", "." + name + ".tmp");
            try (InputStream is = url.openStream();){
                Files.copy(is, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            tmpFile.deleteOnExit();
            try {
                System.load(tmpFile.getAbsolutePath());
            }
            catch (Throwable e) {
                Log.error(LOG_COMPONENT, "unable to load JNI library " + name + ": " + e.getClass().getName() + ": " + e.getMessage());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Log.error(LOG_COMPONENT, "unable to load JNI library:" + e.getClass().getName() + ":" + e.getMessage());
            return false;
        }
    }

    public boolean loadByShortName(ClassLoader classLoader, String name) {
        try {
            Log.debug(LOG_COMPONENT, "trying native library loading from the native lain file: " + name);
            System.loadLibrary(name);
            return true;
        }
        catch (Throwable e) {
            Log.debug(LOG_COMPONENT, "not a problem, the library can't be loaded from the native file, will try from a resource: " + e.getClass().getName() + ": " + e.getMessage());
            if (this.os.toLowerCase().startsWith("linux")) {
                return this.load(classLoader, "lib" + name + ".so");
            }
            if (this.os.toLowerCase().startsWith("windows")) {
                return this.load(classLoader, name + ".dll");
            }
            Log.warning(LOG_COMPONENT, "unknown OS name: " + this.os + ", loading JNI by the original name '" + name + "'");
            return this.load(classLoader, name);
        }
    }
}

