/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;

class Keyboard {
    Keyboard() {
    }

    static InputEvent translate(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        InputEvent e = event;
        e = Keyboard.translateControl(e);
        e = Keyboard.translateAlternative(e);
        return e;
    }

    static InputEvent translateAlternative(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!event.isSpecial() || !event.withControlOnly()) {
            return event;
        }
        switch (event.getSpecial()) {
            case ARROW_UP: {
                return new InputEvent(true, InputEvent.Special.ALTERNATIVE_ARROW_UP, ' ');
            }
            case ARROW_DOWN: {
                return new InputEvent(true, InputEvent.Special.ALTERNATIVE_ARROW_DOWN, ' ');
            }
            case ARROW_LEFT: {
                return new InputEvent(true, InputEvent.Special.ALTERNATIVE_ARROW_LEFT, ' ');
            }
            case ARROW_RIGHT: {
                return new InputEvent(true, InputEvent.Special.ALTERNATIVE_ARROW_RIGHT, ' ');
            }
            case PAGE_DOWN: {
                return new InputEvent(true, InputEvent.Special.ALTERNATIVE_PAGE_DOWN, ' ');
            }
            case PAGE_UP: {
                return new InputEvent(true, InputEvent.Special.ALTERNATIVE_PAGE_UP, ' ');
            }
            case HOME: {
                return new InputEvent(true, InputEvent.Special.ALTERNATIVE_HOME, ' ');
            }
            case END: {
                return new InputEvent(true, InputEvent.Special.ALTERNATIVE_END, ' ');
            }
            case DELETE: {
                return new InputEvent(true, InputEvent.Special.ALTERNATIVE_DELETE, ' ');
            }
        }
        return event;
    }

    private static InputEvent translateControl(InputEvent event) {
        if (event.isSpecial()) {
            return event;
        }
        return new InputEvent(Keyboard.translateControlChar(event.getChar()), event.withShift(), event.withControl(), event.withAlt());
    }

    private static char translateControlChar(char c) {
        switch (c) {
            case '\u0001': {
                return 'a';
            }
            case '\u0002': {
                return 'b';
            }
            case '\u0003': {
                return 'c';
            }
            case '\u0004': {
                return 'd';
            }
            case '\u0005': {
                return 'e';
            }
            case '\u0006': {
                return 'f';
            }
            case '\u0007': {
                return 'g';
            }
            case '\u000b': {
                return 'k';
            }
            case '\f': {
                return 'l';
            }
            case '\u000e': {
                return 'n';
            }
            case '\u000f': {
                return 'o';
            }
            case '\u0010': {
                return 'p';
            }
            case '\u0011': {
                return 'q';
            }
            case '\u0012': {
                return 'r';
            }
            case '\u0013': {
                return 's';
            }
            case '\u0014': {
                return 't';
            }
            case '\u0015': {
                return 'u';
            }
            case '\u0016': {
                return 'v';
            }
            case '\u0017': {
                return 'w';
            }
            case '\u0018': {
                return 'x';
            }
            case '\u0019': {
                return 'y';
            }
            case '\u001a': {
                return 'z';
            }
        }
        return c;
    }
}

