/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.lang.reflect.Proxy;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;

public final class RegistryProxy {
    public static <T> T create(Registry registry, String regDir, Class<T> cl) {
        NullCheck.notNull((Object)registry, (String)"registry");
        NullCheck.notNull((Object)regDir, (String)"regDir");
        return (T)Proxy.newProxyInstance(cl.getClassLoader(), new Class[]{cl}, (object, method, args) -> {
            int valueType;
            String name = method.getName();
            if (name.length() <= 3) {
                throw new IllegalArgumentException("'" + name + "' is too short to be a valid method name");
            }
            if (!name.startsWith("get") && !name.startsWith("set")) {
                throw new IllegalArgumentException("Method name should begin with 'get' or 'set', '" + name + "' is an inappropriate name");
            }
            Class<?> returnType = method.getReturnType();
            StringBuilder b = new StringBuilder();
            for (int i = 3; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (i > 3 && Character.isUpperCase(c) && Character.isLowerCase(name.charAt(i - 1))) {
                    b.append("-");
                    b.append(Character.toLowerCase(c));
                    continue;
                }
                b.append(Character.toLowerCase(c));
            }
            String paramName = Registry.join(regDir, new String(b));
            if (returnType.equals(String.class) && name.startsWith("get")) {
                valueType = registry.getTypeOf(paramName);
                if (valueType == 0) {
                    if (args != null && args.length == 1 && args[0] != null && args[0].getClass().equals(String.class)) {
                        return (String)args[0];
                    }
                    throw new IllegalArgumentException("There is no registry value " + paramName);
                }
                if (valueType != 2) {
                    throw new IllegalArgumentException("Registry value " + paramName + " is not a string");
                }
                return registry.getString(paramName);
            }
            if (returnType.equals(Boolean.TYPE) && name.startsWith("get")) {
                valueType = registry.getTypeOf(paramName);
                if (valueType == 0) {
                    if (args != null && args.length == 1 && args[0] != null && args[0].getClass().equals(Boolean.class)) {
                        return (boolean)((Boolean)args[0]);
                    }
                    throw new IllegalArgumentException("There is no registry value " + paramName);
                }
                if (valueType != 3) {
                    throw new IllegalArgumentException("Registry value " + paramName + " is not a boolean");
                }
                return registry.getBoolean(paramName);
            }
            if (returnType.equals(Integer.TYPE) && name.startsWith("get")) {
                valueType = registry.getTypeOf(paramName);
                if (valueType == 0) {
                    if (args != null && args.length == 1 && args[0] != null && args[0].getClass().equals(Integer.class)) {
                        return (int)((Integer)args[0]);
                    }
                    throw new IllegalArgumentException("There is no registry value " + paramName);
                }
                if (valueType != 1) {
                    throw new IllegalArgumentException("Registry value " + paramName + " is not an integer");
                }
                return registry.getInteger(paramName);
            }
            if (name.startsWith("set") && args != null && args.length == 1 && args[0] != null && args[0].getClass().equals(String.class)) {
                if (!registry.setString(paramName, (String)args[0])) {
                    throw new Exception("Unable to write to registry the string value " + paramName);
                }
                return null;
            }
            if (name.startsWith("set") && args != null && args.length == 1 && args[0] != null && args[0].getClass().equals(Integer.class)) {
                if (!registry.setInteger(paramName, (Integer)args[0])) {
                    throw new Exception("Unable to write to registry the integer value " + paramName);
                }
                return null;
            }
            if (name.startsWith("set") && args != null && args.length == 1 && args[0] != null && args[0].getClass().equals(Boolean.class)) {
                if (!registry.setBoolean(paramName, (Boolean)args[0])) {
                    throw new Exception("Unable to write to registry the boolean value " + paramName);
                }
                return null;
            }
            return null;
        });
    }
}

