/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import org.luwrain.core.NullCheck;

public final class Standalone {
    private static final File STANDALONE = new File("standalone");
    private static final String ENV_APP_DATA = "APPDATA";
    private static final String ENV_USER_PROFILE = "USERPROFILE";
    private final boolean standalone;
    private final File dataDir;

    public Standalone(String unixDataDirName, String winDataDirName) {
        NullCheck.notEmpty((Object)unixDataDirName, (String)"unixDataDirName");
        NullCheck.notNull((Object)winDataDirName, (String)"winDataDirName");
        boolean bl = this.standalone = STANDALONE.exists() && STANDALONE.isFile();
        if (System.getenv().containsKey(ENV_APP_DATA) && !System.getenv().get(ENV_APP_DATA).trim().isEmpty()) {
            File appData = new File(System.getenv().get(ENV_APP_DATA));
            this.dataDir = new File(appData, winDataDirName);
        } else if (System.getenv().containsKey(ENV_USER_PROFILE) && !System.getenv().get(ENV_USER_PROFILE).trim().isEmpty()) {
            File userProfile = new File(System.getenv().get(ENV_USER_PROFILE));
            this.dataDir = new File(new File(new File(userProfile, "Local Settings"), "Application Data"), winDataDirName);
        } else {
            File f = new File(System.getProperty("user.home"));
            this.dataDir = new File(f, "." + unixDataDirName);
        }
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public File getDataDir() {
        return this.dataDir;
    }
}

