/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.HashMap;
import java.util.Map;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.UniRefInfo;
import org.luwrain.core.UniRefProc;

final class UniRefProcManager {
    private static final UniRefInfo EMPTY = new UniRefInfo("empty:", "empty", "", "");
    private final Map<String, Entry> uniRefProcs = new HashMap<String, Entry>();

    UniRefProcManager() {
    }

    boolean add(Luwrain luwrain, UniRefProc uniRefProc) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)uniRefProc, (String)"uniRefProc");
        String uniRefType = uniRefProc.getUniRefType();
        if (uniRefType == null || uniRefType.trim().isEmpty()) {
            return false;
        }
        if (this.uniRefProcs.containsKey(uniRefType)) {
            return false;
        }
        this.uniRefProcs.put(uniRefType, new Entry(luwrain, uniRefType, uniRefProc));
        return true;
    }

    UniRefInfo getInfo(String uniRef) {
        NullCheck.notNull((Object)uniRef, (String)"uniRef");
        if (uniRef.trim().isEmpty()) {
            return EMPTY;
        }
        String uniRefType = this.getUniRefType(uniRef);
        if (uniRefType == null || uniRefType.trim().isEmpty()) {
            return new UniRefInfo("static:" + uniRef.trim(), "static", "", uniRef.trim());
        }
        if (!this.uniRefProcs.containsKey(uniRefType)) {
            return new UniRefInfo(uniRef);
        }
        Entry entry = this.uniRefProcs.get(uniRefType);
        UniRefInfo res = entry.uniRefProc.getUniRefInfo(uniRef);
        if (res == null) {
            return new UniRefInfo(uniRef);
        }
        return res;
    }

    boolean open(String uniRef) {
        NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
        String uniRefType = this.getUniRefType(uniRef);
        if (uniRefType == null || uniRefType.trim().isEmpty()) {
            return false;
        }
        if (!this.uniRefProcs.containsKey(uniRefType)) {
            return false;
        }
        Entry entry = this.uniRefProcs.get(uniRefType);
        return entry.uniRefProc.openUniRef(uniRef, entry.luwrain);
    }

    private String getUniRefType(String uniRef) {
        int pos = uniRef.indexOf(58);
        if (pos < 1) {
            return null;
        }
        for (int i = 0; i < pos; ++i) {
            if (!Character.isSpaceChar(i) && !Character.isWhitespace(uniRef.charAt(i)) && !Character.isISOControl(uniRef.charAt(i))) continue;
            return null;
        }
        return uniRef.substring(0, pos);
    }

    private static final class Entry {
        final Luwrain luwrain;
        final String uniRefType;
        final UniRefProc uniRefProc;

        Entry(Luwrain luwrain, String uniRefType, UniRefProc uniRefProc) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            NullCheck.notNull((Object)uniRefType, (String)"uniRefType");
            NullCheck.notNull((Object)uniRefProc, (String)"uniRefProc");
            if (uniRefType.trim().isEmpty()) {
                throw new IllegalArgumentException("uniRefType may not be empty");
            }
            this.luwrain = luwrain;
            this.uniRefType = uniRefType;
            this.uniRefProc = uniRefProc;
        }
    }
}

