/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.events;

import org.luwrain.core.Event;
import org.luwrain.core.NullCheck;

public class SystemEvent
extends Event {
    protected final Code code;
    protected final Type type;
    protected final String broadcastFilterAreaClassName;
    protected final String broadcastFilterUniRef;

    public SystemEvent(Code code) {
        NullCheck.notNull((Object)((Object)code), (String)"code");
        this.type = Type.REGULAR;
        this.code = code;
        this.broadcastFilterAreaClassName = null;
        this.broadcastFilterUniRef = null;
    }

    public SystemEvent(Type type, Code code) {
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notNull((Object)((Object)code), (String)"code");
        this.type = type;
        this.code = code;
        this.broadcastFilterAreaClassName = null;
        this.broadcastFilterUniRef = null;
    }

    public SystemEvent(Type type, Code code, String broadcastFilterAreaClassName, String broadcastFilterUniRef) {
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notNull((Object)((Object)code), (String)"code");
        this.type = type;
        this.code = code;
        this.broadcastFilterAreaClassName = broadcastFilterAreaClassName;
        this.broadcastFilterUniRef = broadcastFilterUniRef;
    }

    public final Code getCode() {
        return this.code;
    }

    public final Type getType() {
        return this.type != null ? this.type : Type.REGULAR;
    }

    public String getBroadcastFilterAreaClassName() {
        return this.broadcastFilterAreaClassName != null ? this.broadcastFilterAreaClassName : "";
    }

    public String getBroadcastFilterUniRef() {
        return this.broadcastFilterUniRef != null ? this.broadcastFilterUniRef : "";
    }

    public static enum Type {
        REGULAR,
        BROADCAST;

    }

    public static enum Code {
        ACTION,
        ANNOUNCE_LINE,
        CANCEL,
        CLEAR,
        CLEAR_REGION,
        CLIPBOARD_COPY,
        CLIPBOARD_COPY_ALL,
        CLIPBOARD_CUT,
        CLIPBOARD_PASTE,
        CLOSE,
        FONT_SIZE_CHANGED,
        HELP,
        INTRODUCE,
        IDLE,
        LISTENING_FINISHED,
        MOVE_HOT_POINT,
        OK,
        PROPERTIES,
        REFRESH,
        REGION_POINT,
        SAVE,
        USER;

    }
}

