/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.listening;

import org.luwrain.core.Area;
import org.luwrain.core.ListenableArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Settings;
import org.luwrain.core.Speech;
import org.luwrain.core.listening.CompatArea;
import org.luwrain.core.listening.PlainArea;
import org.luwrain.speech.Channel;

public final class Listening {
    private final Luwrain luwrain;
    private final Speech speech;
    private final Runnable completion;
    private final Settings.SpeechParams sett;
    private final Channel channel;
    private final Area area;
    private ListenableArea listenableArea = null;

    public Listening(Luwrain luwrain, Speech speech, Area area, Runnable completion) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)speech, (String)"speech");
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)completion, (String)"completion");
        this.luwrain = luwrain;
        this.speech = speech;
        this.area = area;
        this.completion = completion;
        this.sett = null;
        if (this.sett.getListeningEngineName("").isEmpty()) {
            this.channel = null;
            return;
        }
        this.channel = speech.loadChannel(this.sett.getListeningEngineName(""), this.sett.getListeningEngineParams(""));
    }

    public boolean start() {
        if (this.channel == null) {
            return false;
        }
        if (this.area instanceof ListenableArea) {
            this.listenableArea = (ListenableArea)((Object)this.area);
            ListenableArea.ListeningInfo info = this.listenableArea.onListeningStart();
            if (info == null || info.noMore()) {
                this.listenableArea = null;
                this.channel.close();
                return false;
            }
            this.speak(info);
            return true;
        }
        this.listenableArea = new CompatArea(this.area);
        ListenableArea.ListeningInfo info = this.listenableArea.onListeningStart();
        if (info != null && !info.noMore()) {
            this.speak(info);
            return true;
        }
        this.listenableArea = new PlainArea(this.area);
        info = this.listenableArea.onListeningStart();
        if (info != null && !info.noMore()) {
            this.speak(info);
            return true;
        }
        this.listenableArea = null;
        this.channel.close();
        return false;
    }

    public void cancel() {
        if (this.channel == null || this.listenableArea == null) {
            return;
        }
        this.channel.silence();
        this.channel.close();
        this.listenableArea = null;
        this.completion.run();
    }

    private void onFinish(ListenableArea.ListeningInfo listeningInfo) {
        NullCheck.notNull((Object)listeningInfo, (String)"listeningInfo");
        if (this.listenableArea == null) {
            return;
        }
        this.listenableArea.onListeningFinish(listeningInfo);
        ListenableArea.ListeningInfo nextInfo = this.listenableArea.onListeningStart();
        if (nextInfo == null || nextInfo.noMore()) {
            this.listenableArea = null;
            this.channel.close();
            this.completion.run();
            return;
        }
        this.speak(nextInfo);
    }

    private void speak(ListenableArea.ListeningInfo listeningInfo) {
        NullCheck.notNull((Object)listeningInfo, (String)"listeningInfo");
        Channel.Listener listener = id -> this.luwrain.runUiSafely(() -> this.onFinish(listeningInfo));
        this.channel.speak(this.luwrain.getSpeakableText(listeningInfo.getText(), Luwrain.SpeakableTextType.NATURAL), listener, this.sett.getListeningPitch(50) - 50, 50 - this.sett.getListeningRate(50), false);
    }
}

