/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.luwrain.core.NullCheck;

final class RegistryExtractor {
    private static final String DIR_PREFIX = "DIR ";
    private static final String FILE_PREFIX = "FILE ";
    private final File destDir;
    private File currentDir = null;
    private File currentFile = null;
    private final List<String> lines = new ArrayList<String>();

    RegistryExtractor(File destDir) {
        NullCheck.notNull((Object)destDir, (String)"destDir");
        this.destDir = destDir;
    }

    void extract(InputStream is) throws IOException {
        NullCheck.notNull((Object)is, (String)"is");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') {
                line = reader.readLine();
                continue;
            }
            if (line.startsWith(DIR_PREFIX)) {
                this.onDir(line.substring(DIR_PREFIX.length()).trim());
            } else if (line.startsWith(FILE_PREFIX)) {
                this.onFile(line.substring(FILE_PREFIX.length()).trim());
            } else {
                this.onValue(line);
            }
            line = reader.readLine();
        }
        this.saveLines();
    }

    private void onDir(String path) throws IOException {
        NullCheck.notNull((Object)path, (String)"path");
        if (path.isEmpty()) {
            return;
        }
        this.saveLines();
        this.currentDir = new File(this.destDir, path);
        RegistryExtractor.createDirectories(this.currentDir);
        new File(this.currentDir, "strings.txt").createNewFile();
        new File(this.currentDir, "integers.txt").createNewFile();
        new File(this.currentDir, "booleans.txt").createNewFile();
    }

    private void onFile(String fileName) throws IOException {
        NullCheck.notNull((Object)fileName, (String)"fileName");
        if (fileName.isEmpty()) {
            return;
        }
        if (this.currentDir == null) {
            return;
        }
        this.saveLines();
        this.currentFile = new File(this.currentDir, fileName);
        this.currentFile.createNewFile();
    }

    private void onValue(String line) throws IOException {
        NullCheck.notNull((Object)line, (String)"line");
        if (line.isEmpty()) {
            return;
        }
        if (this.currentDir == null || this.currentFile == null) {
            return;
        }
        this.lines.add(line);
    }

    private void saveLines() throws IOException {
        if (this.currentDir == null || this.currentFile == null) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentFile, true), "UTF-8"));){
            for (String s : this.lines) {
                writer.write(s);
                writer.newLine();
            }
        }
        this.lines.clear();
    }

    private static void createDirectories(File file) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        LinkedList<File> files = new LinkedList<File>();
        for (File f = file; f != null; f = f.getParentFile()) {
            files.add(f);
        }
        while (!files.isEmpty()) {
            File dir = (File)files.pollLast();
            if (dir.isDirectory()) continue;
            dir.mkdir();
        }
    }
}

