/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n;

import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.ReadOnlyFileSystemException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.i18n.EmptyStringsObj;
import org.luwrain.i18n.I18n;
import org.luwrain.i18n.I18nExtension;
import org.luwrain.i18n.Lang;
import org.luwrain.i18n.LangStatic;

public final class I18nImpl
implements I18n,
I18nExtension {
    private static final Logger log = LogManager.getLogger();
    private static final String EN_LANG = "en";
    private static final String NO_SELECTED_LANG = "#NO SELECTED LANGUAGE#";
    private Lang selectedLang = null;
    private String selectedLangName = "";
    private final List<CommandTitle> commandTitles = new ArrayList<CommandTitle>();
    private final List<StringsObj> stringsObjs = new ArrayList<StringsObj>();
    private final Map<String, Lang> langs = new HashMap<String, Lang>();

    @Override
    public Lang getActiveLang() {
        return this.selectedLang;
    }

    @Override
    public Map<String, Lang> getAllLangs() {
        return new HashMap<String, Lang>(this.langs);
    }

    @Override
    public Lang getLang(String langName) {
        NullCheck.notEmpty((Object)langName, (String)"langName");
        return this.langs.containsKey(langName) ? this.langs.get(langName) : null;
    }

    public String getSpeakableText(String text, Luwrain.SpeakableTextType speakableTextType) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)speakableTextType), (String)"speakableTextType");
        if (this.selectedLang == null) {
            return NO_SELECTED_LANG;
        }
        try {
            String value = this.selectedLang.getSpeakableText(text, speakableTextType);
            return value != null ? value : text;
        }
        catch (Throwable e) {
            log.error("Unable to make a speakable text of type " + String.valueOf((Object)speakableTextType) + ": " + e.getClass().getName() + ": " + e.getMessage());
            return text;
        }
    }

    @Override
    public String getPastTimeBrief(Date date) {
        NullCheck.notNull((Object)date, (String)"date");
        if (this.selectedLang == null) {
            return NO_SELECTED_LANG;
        }
        String value = this.selectedLang.pastTimeBrief(date);
        return value != null ? value : "";
    }

    @Override
    public String getExceptionDescr(Exception e) {
        NullCheck.notNull((Object)e, (String)"e");
        if (e instanceof NoSuchFileException) {
            return e.getMessage() + ":\u043d\u0435\u0442 \u0442\u0430\u043a\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430";
        }
        if (e instanceof AccessDeniedException) {
            return e.getMessage() + ":\u043e\u0442\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0435";
        }
        if (e instanceof DirectoryNotEmptyException) {
            return e.getMessage() + ":\u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u043d\u0435 \u043f\u0443\u0441\u0442";
        }
        if (e instanceof DirectoryNotEmptyException) {
            return e.getMessage() + ":\u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u043d\u0435 \u043f\u0443\u0441\u0442";
        }
        if (e instanceof FileAlreadyExistsException) {
            return e.getMessage() + ":\u0444\u0430\u0439\u043b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442";
        }
        if (e instanceof InvalidPathException) {
            return e.getMessage() + ":\u043d\u0435\u0432\u0435\u0440\u043d\u043e \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443";
        }
        if (e instanceof NotDirectoryException) {
            return e.getMessage() + ":\u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u043e\u043c";
        }
        if (e instanceof NotLinkException) {
            return e.getMessage() + ":\u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439";
        }
        if (e instanceof ReadOnlyFileSystemException) {
            return e.getMessage() + ":\u0444\u0430\u0439\u043b\u043e\u0432\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f";
        }
        return e.getMessage() + ":" + e.getClass().getName();
    }

    @Override
    public String getNumberStr(int count, String entities) {
        NullCheck.notNull((Object)entities, (String)"entities");
        if (this.selectedLang == null) {
            return NO_SELECTED_LANG;
        }
        String value = this.selectedLang.getNumberStr(count, entities);
        return value != null ? value : "";
    }

    @Override
    public String staticStr(LangStatic id) {
        Objects.requireNonNull(id, "id can't be null");
        return this.getStaticStr(I18nImpl.convertStaticValueName(id.toString()));
    }

    @Override
    public String getStaticStr(String id) {
        Objects.requireNonNull(id, "id can't be null");
        if (this.selectedLang == null) {
            return NO_SELECTED_LANG;
        }
        String value = this.selectedLang.getStaticStr(id);
        return value != null && !value.isEmpty() ? value : "#" + id + "#";
    }

    @Override
    public String hasSpecialNameOfChar(char ch) {
        return this.selectedLang != null ? this.selectedLang.hasSpecialNameOfChar(ch) : null;
    }

    @Override
    public String getCommandTitle(String command) {
        NullCheck.notEmpty((Object)command, (String)"command");
        String selectedLangValue = null;
        String enLangValue = null;
        String anyLangValue = null;
        for (CommandTitle t : this.commandTitles) {
            if (!t.command.equals(command)) continue;
            if (anyLangValue == null) {
                anyLangValue = t.title;
            }
            if (t.lang.equals(this.selectedLangName)) {
                selectedLangValue = t.title;
            }
            if (!t.lang.equals(EN_LANG)) continue;
            enLangValue = t.title;
        }
        if (selectedLangValue != null) {
            return selectedLangValue;
        }
        if (enLangValue != null) {
            return enLangValue;
        }
        return anyLangValue != null ? anyLangValue : command;
    }

    @Override
    public void addCommandTitle(String lang, String command, String title) {
        NullCheck.notEmpty((Object)lang, (String)"lang");
        NullCheck.notEmpty((Object)command, (String)"command");
        NullCheck.notEmpty((Object)title, (String)"title");
        for (CommandTitle t : this.commandTitles) {
            if (!t.lang.equals(lang) || !t.command.equals(command)) continue;
            return;
        }
        this.commandTitles.add(new CommandTitle(lang, command, title));
    }

    @Override
    public Object getStrings(String component) {
        Objects.requireNonNull(component, "component");
        if (component.isEmpty()) {
            throw new IllegalArgumentException("component can't be empty");
        }
        Object selectedLangObj = null;
        Object enLangObj = null;
        Object anyLangObj = null;
        for (StringsObj o : this.stringsObjs) {
            if (!o.component.equals(component)) continue;
            if (anyLangObj == null) {
                anyLangObj = o.obj;
            }
            if (o.lang.equals(this.selectedLangName)) {
                selectedLangObj = o.obj;
            }
            if (!o.lang.equals(EN_LANG)) continue;
            enLangObj = o.obj;
        }
        if (selectedLangObj != null) {
            return selectedLangObj;
        }
        if (enLangObj != null) {
            return enLangObj;
        }
        return anyLangObj;
    }

    @Override
    public <E> E getStrings(Class<E> stringsClass) {
        Objects.requireNonNull(stringsClass, "stringsClass");
        Object selectedLangObj = null;
        Object enLangObj = null;
        Object anyLangObj = null;
        for (StringsObj o : this.stringsObjs) {
            if (!o.component.equals(stringsClass.getName())) continue;
            anyLangObj = o.obj;
            if (o.lang.equals(this.selectedLangName)) {
                selectedLangObj = o.obj;
            }
            if (!o.lang.equals(EN_LANG)) continue;
            enLangObj = o.obj;
        }
        if (selectedLangObj != null) {
            return (E)selectedLangObj;
        }
        if (enLangObj != null) {
            return (E)enLangObj;
        }
        if (anyLangObj != null) {
            return (E)anyLangObj;
        }
        log.warn("Creating an empty strings object for the class " + stringsClass.getName());
        return (E)new EmptyStringsObj().create(stringsClass.getClassLoader(), stringsClass);
    }

    @Override
    public void addStrings(String lang, String component, Object obj) {
        Objects.requireNonNull(lang, "lang can't be null");
        Objects.requireNonNull(component, "component can't be null");
        Objects.requireNonNull(obj, "obj can't be null");
        for (StringsObj o : this.stringsObjs) {
            if (!o.lang.equals(lang) || !o.component.equals(component)) continue;
            return;
        }
        log.trace("Adding a strings object " + component + " for the language  " + lang);
        this.stringsObjs.add(new StringsObj(lang, component, obj));
    }

    @Override
    public boolean addLang(String name, Lang lang) {
        Objects.requireNonNull(name, "name can't be null");
        Objects.requireNonNull(lang, "lang can't be null");
        if (this.langs.containsKey(name)) {
            log.warn("Trying to add the language  " + name + " twice");
            return false;
        }
        log.trace("Adding a lang " + name);
        this.langs.put(name, lang);
        return true;
    }

    public boolean selectLang(String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        if (this.langs.isEmpty()) {
            log.error("No langs registered, unable to choose the default");
            return false;
        }
        for (Map.Entry<String, Lang> l : this.langs.entrySet()) {
            log.trace("Lang '" + l.getKey() + "' loaded");
        }
        Lang preferableLang = null;
        String preferableLangName = "";
        Lang anyLang = null;
        String anyLangName = "";
        Lang enLang = null;
        for (Map.Entry<String, Lang> l : this.langs.entrySet()) {
            if (anyLang == null) {
                anyLang = l.getValue();
                anyLangName = l.getKey();
            }
            if (l.getKey().equals(name)) {
                preferableLang = l.getValue();
                preferableLangName = name;
            }
            if (!l.getKey().equals(EN_LANG)) continue;
            enLang = l.getValue();
        }
        if (preferableLang == null) {
            log.warn("The preferable language '" + name + "' not found");
        }
        if (enLang == null) {
            log.warn("English language not found");
        }
        if (preferableLang != null) {
            this.selectedLang = preferableLang;
            this.selectedLangName = preferableLangName;
        } else if (enLang != null) {
            this.selectedLang = enLang;
            this.selectedLangName = EN_LANG;
        } else {
            this.selectedLang = anyLang;
            this.selectedLangName = anyLangName;
        }
        log.debug("the selected language is '" + this.selectedLangName + "'");
        return true;
    }

    String getSelectedLangName() {
        return this.selectedLangName;
    }

    private static String convertStaticValueName(String name) {
        StringBuilder b = new StringBuilder();
        boolean nextCap = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                nextCap = true;
                continue;
            }
            if (nextCap) {
                b.append(Character.toUpperCase(c));
            } else {
                b.append(Character.toLowerCase(c));
            }
            nextCap = false;
        }
        return b.toString();
    }

    private static final class CommandTitle {
        final String lang;
        final String command;
        final String title;

        CommandTitle(String lang, String command, String title) {
            NullCheck.notEmpty((Object)lang, (String)"lang");
            NullCheck.notEmpty((Object)command, (String)"command");
            NullCheck.notEmpty((Object)title, (String)"title");
            this.lang = lang;
            this.command = command;
            this.title = title;
        }
    }

    private static final class StringsObj {
        final String lang;
        final String component;
        final Object obj;

        StringsObj(String lang, String component, Object obj) {
            NullCheck.notEmpty((Object)lang, (String)"lang");
            NullCheck.notEmpty((Object)component, (String)"component");
            NullCheck.notNull((Object)obj, (String)"obj");
            this.lang = lang;
            this.component = component;
            this.obj = obj;
        }
    }
}

